/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.query.IterableWithScores;
import com.mware.ge.query.QueryBase;
import com.mware.ge.query.QueryParameters;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.QueryStringQueryParameters;
import com.mware.ge.query.ScoringStrategyComparator;
import com.mware.ge.query.SortContainersComparator;
import com.mware.ge.query.aggregations.AggregationResult;
import com.mware.ge.scoring.ScoringStrategy;
import com.mware.ge.util.CloseableIterator;
import com.mware.ge.util.CloseableUtils;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.StreamingPropertyValue;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultGraphQueryIterable<T>
implements Iterable<T>,
QueryResultsIterable<T>,
IterableWithScores<T> {
    private final QueryParameters parameters;
    private final Iterable<T> iterable;
    private final boolean evaluateQueryString;
    private final boolean evaluateHasContainers;

    public DefaultGraphQueryIterable(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers) {
        Preconditions.checkNotNull(iterable, "iterable cannot be null");
        this.parameters = parameters;
        this.evaluateQueryString = evaluateQueryString;
        this.evaluateHasContainers = evaluateHasContainers;
        this.iterable = evaluateSortContainers && this.parameters.getSortContainers().size() > 0 ? this.sortUsingSortContainers(iterable, parameters.getSortContainers()) : (evaluateHasContainers && this.parameters.getScoringStrategy() != null ? this.sortUsingScoringStrategy(iterable, parameters.getScoringStrategy()) : iterable);
    }

    private Iterable<T> sortUsingScoringStrategy(Iterable<T> iterable, ScoringStrategy scoringStrategy) {
        List<T> list = IterableUtils.toList(iterable);
        list.sort(new ScoringStrategyComparator(scoringStrategy));
        return list;
    }

    private List<T> sortUsingSortContainers(Iterable<T> iterable, List<QueryBase.SortContainer> sortContainers) {
        List<T> list = IterableUtils.toList(iterable);
        list.sort(new SortContainersComparator(sortContainers));
        return list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    protected Iterator<T> iterator(final boolean iterateAll) {
        final Iterator<T> it = this.iterable.iterator();
        return new CloseableIterator<T>(){
            public T next;
            public T current;
            public long count;

            @Override
            public boolean hasNext() {
                this.loadNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.loadNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
                DefaultGraphQueryIterable.this.close();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                if (!iterateAll && DefaultGraphQueryIterable.this.parameters.getLimit() != null && this.count >= DefaultGraphQueryIterable.this.parameters.getSkip() + DefaultGraphQueryIterable.this.parameters.getLimit()) {
                    return;
                }
                while (it.hasNext()) {
                    Object elem = it.next();
                    GeObject geElem = elem instanceof GeObject ? (GeObject)elem : null;
                    boolean match = true;
                    if (DefaultGraphQueryIterable.this.evaluateHasContainers && geElem != null) {
                        for (QueryBase.HasContainer has : DefaultGraphQueryIterable.this.parameters.getHasContainers()) {
                            if (has.isMatch(geElem)) continue;
                            match = false;
                            break;
                        }
                        if (geElem instanceof Edge && DefaultGraphQueryIterable.this.parameters.getEdgeLabels().size() > 0) {
                            Edge edge = (Edge)geElem;
                            if (!DefaultGraphQueryIterable.this.parameters.getEdgeLabels().contains(edge.getLabel())) {
                                match = false;
                            }
                        }
                        if (geElem instanceof Vertex && DefaultGraphQueryIterable.this.parameters.getConceptTypes().size() > 0) {
                            Vertex vertex = (Vertex)geElem;
                            if (!DefaultGraphQueryIterable.this.parameters.getConceptTypes().contains(vertex.getConceptType())) {
                                match = false;
                            }
                        }
                        if (DefaultGraphQueryIterable.this.parameters.getIds() != null) {
                            if (geElem instanceof Element) {
                                if (!DefaultGraphQueryIterable.this.parameters.getIds().contains(((Element)geElem).getId())) {
                                    match = false;
                                }
                            } else if (geElem instanceof ExtendedDataRow) {
                                if (!DefaultGraphQueryIterable.this.parameters.getIds().contains(((ExtendedDataRow)geElem).getId().getElementId())) {
                                    match = false;
                                }
                            } else {
                                throw new GeException("Unhandled element type: " + geElem.getClass().getName());
                            }
                        }
                        if (DefaultGraphQueryIterable.this.parameters.getMinScore() != null) {
                            if (DefaultGraphQueryIterable.this.parameters.getScoringStrategy() == null) {
                                match = false;
                            } else {
                                Double elementScore = DefaultGraphQueryIterable.this.parameters.getScoringStrategy().getScore(geElem);
                                if (elementScore == null) {
                                    match = false;
                                } else {
                                    boolean bl = match = elementScore >= DefaultGraphQueryIterable.this.parameters.getMinScore();
                                }
                            }
                        }
                    }
                    if (!match || DefaultGraphQueryIterable.this.evaluateQueryString && geElem != null && DefaultGraphQueryIterable.this.parameters instanceof QueryStringQueryParameters && ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString() != null && !DefaultGraphQueryIterable.this.evaluateQueryString(geElem, ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString())) continue;
                    ++this.count;
                    if (!iterateAll && this.count <= DefaultGraphQueryIterable.this.parameters.getSkip()) continue;
                    this.next = elem;
                    break;
                }
            }
        };
    }

    protected boolean evaluateQueryString(GeObject geObject, String queryString) {
        if (geObject instanceof Element) {
            return this.evaluateQueryString((Element)geObject, queryString);
        }
        if (geObject instanceof ExtendedDataRow) {
            return this.evaluateQueryString((ExtendedDataRow)geObject, queryString);
        }
        throw new GeException("Unhandled GeObject type: " + geObject.getClass().getName());
    }

    private boolean evaluateQueryString(Element element, String queryString) {
        for (Property property : element.getProperties()) {
            if (!this.evaluateQueryStringOnValue(property.getValue(), queryString)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateQueryString(ExtendedDataRow extendedDataRow, String queryString) {
        for (Property property : extendedDataRow.getProperties()) {
            if (!this.evaluateQueryStringOnValue(property.getValue(), queryString)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateQueryStringOnValue(Object value, String queryString) {
        if (value == null) {
            return false;
        }
        if (queryString.equals("*")) {
            return true;
        }
        if (value instanceof StreamingPropertyValue) {
            value = ((StreamingPropertyValue)value).readToString();
        }
        String valueString = value.toString().toLowerCase();
        return valueString.contains(queryString.toLowerCase());
    }

    @Override
    public long getTotalHits() {
        return IterableUtils.count(this.iterator(true));
    }

    @Override
    public void close() {
        CloseableUtils.closeQuietly(this.iterable);
    }

    @Override
    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        throw new GeException("Could not find aggregation with name: " + name);
    }

    @Override
    public Double getScore(Object id) {
        GeObject GeObject2;
        if (this.parameters.getScoringStrategy() != null && (GeObject2 = this.findGeObjectById(id)) != null) {
            return this.parameters.getScoringStrategy().getScore(GeObject2);
        }
        return 0.0;
    }

    private GeObject findGeObjectById(Object id) {
        Iterator<T> it = this.iterator(true);
        while (it.hasNext()) {
            GeObject GeObject2;
            T obj = it.next();
            if (!(obj instanceof GeObject) || !(GeObject2 = (GeObject)obj).getId().equals(id)) continue;
            return GeObject2;
        }
        return null;
    }
}

