/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.Vertex;
import com.mware.ge.query.DefaultGraphQueryIterable;
import com.mware.ge.query.QueryParameters;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.AggregationResult;
import com.mware.ge.query.aggregations.CardinalityAggregation;
import com.mware.ge.query.aggregations.CardinalityResult;
import com.mware.ge.query.aggregations.ChronoFieldAggregation;
import com.mware.ge.query.aggregations.HistogramBucket;
import com.mware.ge.query.aggregations.HistogramResult;
import com.mware.ge.query.aggregations.TermsAggregation;
import com.mware.ge.query.aggregations.TermsBucket;
import com.mware.ge.query.aggregations.TermsResult;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultGraphQueryIterableWithAggregations<T extends GeObject>
extends DefaultGraphQueryIterable<T> {
    private final Collection<Aggregation> aggregations;

    public DefaultGraphQueryIterableWithAggregations(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, Collection<Aggregation> aggregations) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers, evaluateSortContainers);
        this.aggregations = aggregations;
    }

    @Override
    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        for (Aggregation agg : this.aggregations) {
            if (!agg.getAggregationName().equals(name)) continue;
            return this.getAggregationResult(agg, this.iterator(true));
        }
        return super.getAggregationResult(name, resultType);
    }

    public static boolean isAggregationSupported(Aggregation agg) {
        if (agg instanceof TermsAggregation) {
            return true;
        }
        if (agg instanceof ChronoFieldAggregation) {
            return true;
        }
        return agg instanceof CardinalityAggregation;
    }

    public <TResult extends AggregationResult> TResult getAggregationResult(Aggregation agg, Iterator<T> it) {
        if (agg instanceof TermsAggregation) {
            return (TResult)this.getTermsAggregationResult((TermsAggregation)agg, it);
        }
        if (agg instanceof ChronoFieldAggregation) {
            return (TResult)this.getCalendarFieldHistogramResult((ChronoFieldAggregation)agg, it);
        }
        if (agg instanceof CardinalityAggregation) {
            return (TResult)this.getCardinalityAggregationResult((CardinalityAggregation)agg, it);
        }
        throw new GeException("Unhandled aggregation: " + agg.getClass().getName());
    }

    private CardinalityResult getCardinalityAggregationResult(CardinalityAggregation agg, Iterator<T> it) {
        String fieldName = agg.getPropertyName();
        if ("__ID__".equals(fieldName) || "__edgeLabel".equals(fieldName) || "__outVertexId".equals(fieldName) || "__inVertexId".equals(fieldName) || "__extendedDataTableName".equals(fieldName) || "__extendedDataRowId".equals(fieldName) || "__extendedDataElementId".equals(fieldName) || "__extendedDataElementType".equals(fieldName)) {
            HashSet<Value> values = new HashSet<Value>();
            while (it.hasNext()) {
                GeObject geObject = (GeObject)it.next();
                Iterable<Value> propertyValues = geObject.getPropertyValues(fieldName);
                for (Value propertyValue : propertyValues) {
                    values.add(propertyValue);
                }
            }
            return new CardinalityResult(values.size());
        }
        throw new GeException("Cannot use cardinality aggregation on properties with visibility: " + fieldName);
    }

    private TermsResult getTermsAggregationResult(TermsAggregation agg, Iterator<T> it) {
        String propertyName = agg.getPropertyName();
        Map<Object, List<T>> elementsByProperty = this.getElementsByProperty(it, propertyName, o -> {
            if (o instanceof Value) {
                return ((Value)o).asObjectCopy();
            }
            return o;
        });
        elementsByProperty = this.collapseBucketsByCase(elementsByProperty);
        long other = 0L;
        ArrayList<TermsBucket> buckets = new ArrayList<TermsBucket>();
        for (Map.Entry<Object, List<T>> entry : elementsByProperty.entrySet()) {
            Object key = entry.getKey();
            int count = entry.getValue().size();
            if (agg.getSize() == null || buckets.size() < agg.getSize()) {
                Map<String, AggregationResult> nestedResults = this.getNestedResults(agg.getNestedAggregations(), entry.getValue());
                buckets.add(new TermsBucket(key, count, nestedResults));
                continue;
            }
            other += (long)count;
        }
        return new TermsResult(buckets, other, 0L);
    }

    private Map<Object, List<T>> collapseBucketsByCase(Map<Object, List<T>> elementsByProperty) {
        HashMap<String, List> stringEntries = new HashMap<String, List>();
        HashMap<Object, List<T>> results = new HashMap<Object, List<T>>();
        for (Map.Entry<Object, List<T>> entry : elementsByProperty.entrySet()) {
            if (entry.getKey() instanceof String) {
                String lowerCaseKey = ((String)entry.getKey()).toLowerCase();
                List l2 = stringEntries.computeIfAbsent(lowerCaseKey, s -> new ArrayList());
                l2.add(entry);
                continue;
            }
            results.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, List<Object>> entry : stringEntries.entrySet()) {
            results.put(this.findBestKey(entry.getValue()), entry.getValue().stream().flatMap(l -> ((List)l.getValue()).stream()).collect(Collectors.toList()));
        }
        return results;
    }

    private Object findBestKey(List<Map.Entry<Object, List<T>>> value) {
        int longestListLength = 0;
        String longestString = null;
        for (Map.Entry<Object, List<T>> entry : value) {
            if (entry.getValue().size() < longestListLength) continue;
            longestListLength = entry.getValue().size();
            longestString = (String)entry.getKey();
        }
        return longestString;
    }

    private HistogramResult getCalendarFieldHistogramResult(ChronoFieldAggregation agg, Iterator<T> it) {
        String propertyName = agg.getPropertyName();
        Map<Integer, List<T>> elementsByProperty = this.getElementsByProperty(it, propertyName, o -> {
            DateTimeValue d = (DateTimeValue)o;
            ZonedDateTime zdt = ((ZonedDateTime)d.asObjectCopy()).withZoneSameLocal(agg.getTimeZone().toZoneId());
            return zdt.get(agg.getChronoField());
        });
        HashMap<Integer, HistogramBucket> buckets = new HashMap<Integer, HistogramBucket>(24);
        for (Map.Entry<Integer, List<T>> entry : elementsByProperty.entrySet()) {
            int key = entry.getKey();
            int count = entry.getValue().size();
            Map<String, AggregationResult> nestedResults = this.getNestedResults(agg.getNestedAggregations(), entry.getValue());
            buckets.put(key, new HistogramBucket(key, count, nestedResults));
        }
        return new HistogramResult(buckets.values());
    }

    private Map<String, AggregationResult> getNestedResults(Iterable<Aggregation> nestedAggregations, List<T> elements) {
        HashMap<String, AggregationResult> results = new HashMap<String, AggregationResult>();
        for (Aggregation nestedAggregation : nestedAggregations) {
            Object nestedResult = this.getAggregationResult(nestedAggregation, elements.iterator());
            results.put(nestedAggregation.getAggregationName(), (AggregationResult)nestedResult);
        }
        return results;
    }

    private <TKey> Map<TKey, List<T>> getElementsByProperty(Iterator<T> it, String propertyName, ValueConverter<TKey> valueConverter) {
        HashMap<Object, List> elementsByProperty = new HashMap<Object, List>();
        while (it.hasNext()) {
            GeObject geObject = (GeObject)it.next();
            if ("__conceptType".equals(propertyName) && geObject instanceof Vertex) {
                Vertex v = (Vertex)geObject;
                TKey convertedValue = valueConverter.convert(v.getConceptType());
                elementsByProperty.computeIfAbsent(convertedValue, k -> new ArrayList()).add(geObject);
                continue;
            }
            Iterable<Value> values = geObject.getPropertyValues(propertyName);
            for (Value value : values) {
                TKey convertedValue = valueConverter.convert(value);
                elementsByProperty.computeIfAbsent(convertedValue, k -> new ArrayList()).add(geObject);
            }
        }
        return elementsByProperty;
    }

    private static interface ValueConverter<T> {
        public T convert(Object var1);
    }
}

