/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.google.common.base.Joiner;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.FetchHints;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.query.DefaultGraphQueryIterableWithAggregations;
import com.mware.ge.query.MultiVertexQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryBase;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.JoinIterable;
import com.mware.ge.util.VerticesToEdgeIdsIterable;
import java.util.Collection;

public class DefaultMultiVertexQuery
extends QueryBase
implements MultiVertexQuery {
    private final String[] vertexIds;

    public DefaultMultiVertexQuery(Graph graph, String[] vertexIds, String queryString, Authorizations authorizations) {
        super(graph, queryString, authorizations);
        this.vertexIds = vertexIds;
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(FetchHints fetchHints) {
        Iterable<Vertex> vertices = this.getGraph().getVertices(IterableUtils.toIterable(this.getVertexIds()), fetchHints, this.getParameters().getAuthorizations());
        return new DefaultGraphQueryIterableWithAggregations<Vertex>(this.getParameters(), vertices, true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    @Override
    public QueryResultsIterable<Edge> edges(FetchHints fetchHints) {
        Iterable<Vertex> vertices = this.getGraph().getVertices(IterableUtils.toIterable(this.getVertexIds()), fetchHints, this.getParameters().getAuthorizations());
        VerticesToEdgeIdsIterable edgeIds = new VerticesToEdgeIdsIterable(vertices, this.getParameters().getAuthorizations());
        Iterable<Edge> edges = this.getGraph().getEdges(edgeIds, fetchHints, this.getParameters().getAuthorizations());
        return new DefaultGraphQueryIterableWithAggregations<Edge>(this.getParameters(), edges, true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    @Override
    protected QueryResultsIterable<? extends GeObject> extendedData(FetchHints fetchHints) {
        Iterable<Vertex> vertices = this.getGraph().getVertices(IterableUtils.toIterable(this.getVertexIds()), fetchHints, this.getParameters().getAuthorizations());
        VerticesToEdgeIdsIterable edgeIds = new VerticesToEdgeIdsIterable(vertices, this.getParameters().getAuthorizations());
        Iterable<Edge> edges = this.getGraph().getEdges(edgeIds, fetchHints, this.getParameters().getAuthorizations());
        return this.extendedData(fetchHints, new JoinIterable(vertices, edges));
    }

    public String[] getVertexIds() {
        return this.vertexIds;
    }

    @Override
    public String toString() {
        return super.toString() + ", vertexIds=" + Joiner.on((String)", ").join((Object[])this.vertexIds);
    }

    @Override
    public Query setShard(String shardId) {
        return this;
    }
}

