/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.FetchHints;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.query.DefaultGraphQueryIterableWithAggregations;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.VertexQuery;
import com.mware.ge.query.VertexQueryBase;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.util.JoinIterable;
import java.util.Collection;
import java.util.List;

public class DefaultVertexQuery
extends VertexQueryBase
implements VertexQuery {
    public DefaultVertexQuery(Graph graph, Vertex sourceVertex, String queryString, Authorizations authorizations) {
        super(graph, sourceVertex, queryString, authorizations);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(FetchHints fetchHints) {
        Iterable<Vertex> vertices = this.allVertices(fetchHints);
        return new DefaultGraphQueryIterableWithAggregations<Vertex>(this.getParameters(), vertices, true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    private Iterable<Vertex> allVertices(FetchHints fetchHints) {
        List<String> edgeLabels = this.getParameters().getEdgeLabels();
        String[] edgeLabelsArray = edgeLabels == null || edgeLabels.size() == 0 ? null : edgeLabels.toArray(new String[edgeLabels.size()]);
        FilterIterable<Vertex> results = this.getSourceVertex().getVertices(this.getDirection(), edgeLabelsArray, fetchHints, this.getParameters().getAuthorizations());
        if (this.getOtherVertexId() != null) {
            results = new FilterIterable<Vertex>(results){

                @Override
                protected boolean isIncluded(Vertex otherVertex) {
                    return ((String)otherVertex.getId()).equals(DefaultVertexQuery.this.getOtherVertexId());
                }
            };
        }
        if (this.getParameters().getIds() != null) {
            results = new FilterIterable<Vertex>((Iterable)results){

                @Override
                protected boolean isIncluded(Vertex otherVertex) {
                    return DefaultVertexQuery.this.getParameters().getIds().contains(otherVertex.getId());
                }
            };
        }
        return results;
    }

    @Override
    public QueryResultsIterable<Edge> edges(FetchHints fetchHints) {
        Iterable<Edge> edges = this.allEdges(fetchHints);
        return new DefaultGraphQueryIterableWithAggregations<Edge>(this.getParameters(), edges, true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    private Iterable<Edge> allEdges(FetchHints fetchHints) {
        FilterIterable<Edge> results = this.getSourceVertex().getEdges(this.getDirection(), fetchHints, this.getParameters().getAuthorizations());
        if (this.getOtherVertexId() != null) {
            results = new FilterIterable<Edge>(results){

                @Override
                protected boolean isIncluded(Edge edge) {
                    return edge.getOtherVertexId((String)DefaultVertexQuery.this.getSourceVertex().getId()).equals(DefaultVertexQuery.this.getOtherVertexId());
                }
            };
        }
        return results;
    }

    @Override
    protected QueryResultsIterable<? extends GeObject> extendedData(FetchHints extendedDataFetchHints) {
        FetchHints fetchHints = FetchHints.builder().setIncludeExtendedDataTableNames(true).build();
        return this.extendedData(extendedDataFetchHints, new JoinIterable(this.allVertices(fetchHints), this.allEdges(fetchHints)));
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        if (DefaultGraphQueryIterableWithAggregations.isAggregationSupported(aggregation)) {
            return true;
        }
        return super.isAggregationSupported(aggregation);
    }
}

