/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.Graph;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.query.DefaultExtendedDataQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryableIterable;
import java.util.Iterator;

public class ExtendedDataQueryableIterable
implements QueryableIterable<ExtendedDataRow> {
    private final Graph graph;
    private final Element element;
    private final String tableName;
    private final Iterable<? extends ExtendedDataRow> rows;

    public ExtendedDataQueryableIterable(Graph graph, Element element, String tableName, Iterable<? extends ExtendedDataRow> rows) {
        this.graph = graph;
        this.element = element;
        this.tableName = tableName;
        this.rows = rows;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Element getElement() {
        return this.element;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Query query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    @Override
    public Query query(String queryString, Authorizations authorizations) {
        if (this.getGraph() instanceof GraphWithSearchIndex) {
            GraphWithSearchIndex graphWithSearchIndex = (GraphWithSearchIndex)this.getGraph();
            return graphWithSearchIndex.getSearchIndex().queryExtendedData(this.getGraph(), this.getElement(), this.getTableName(), queryString, authorizations);
        }
        return new DefaultExtendedDataQuery(this.getGraph(), this.getElement(), this.getTableName(), queryString, authorizations);
    }

    @Override
    public Iterator<ExtendedDataRow> iterator() {
        return this.rows.iterator();
    }
}

