/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.GeNotSupportedException;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.query.Predicate;
import com.mware.ge.type.GeoShape;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.GeoShapeValue;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public enum GeoCompare implements Predicate
{
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String compareName;

    private GeoCompare(String compareName) {
        this.compareName = compareName;
    }

    public String getCompareName() {
        return this.compareName;
    }

    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Collection<PropertyDefinition> propertyDefinitions) {
        switch (this) {
            case WITHIN: {
                AtomicBoolean hasProperty = new AtomicBoolean(false);
                boolean allMatch = StreamUtils.stream(properties).allMatch(property -> {
                    hasProperty.set(true);
                    return this.evaluate(property.getValue(), second);
                });
                return hasProperty.get() && allMatch;
            }
            case INTERSECTS: {
                return StreamUtils.stream(properties).anyMatch(property -> this.evaluate(property.getValue(), second));
            }
            case DISJOINT: {
                return StreamUtils.stream(properties).noneMatch(property -> this.evaluate(property.getValue(), second));
            }
        }
        throw new IllegalArgumentException("Invalid compare: " + this);
    }

    @Override
    public boolean evaluate(Object first, Object second, PropertyDefinition propertyDefinition) {
        return this.evaluate(first, second);
    }

    @Override
    public void validate(PropertyDefinition propertyDefinition) {
        if (!GeoShapeValue.class.isAssignableFrom(propertyDefinition.getDataType())) {
            throw new GeNotSupportedException("GeoCompare predicates are not allowed for properties of type " + propertyDefinition.getDataType().getName());
        }
    }

    private boolean evaluate(Object testValue, Object second) {
        GeoShape g1 = ((GeoShapeValue)testValue).asObjectCopy();
        GeoShape g2 = ((GeoShapeValue)second).asObjectCopy();
        switch (this) {
            case WITHIN: {
                return g1.within(g2);
            }
            case INTERSECTS: {
                return g2.intersects(g1);
            }
            case DISJOINT: {
                return !g2.intersects(g1);
            }
        }
        throw new IllegalArgumentException("Invalid compare: " + this);
    }
}

