/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.GeObjectType;
import com.mware.ge.Graph;
import com.mware.ge.IdFetchHint;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Conjunction;
import com.mware.ge.query.Contains;
import com.mware.ge.query.DefaultGraphQueryIdIterable;
import com.mware.ge.query.DefaultGraphQueryIterableWithAggregations;
import com.mware.ge.query.GeoCompare;
import com.mware.ge.query.HasExtendedDataFilter;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryParameters;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.QueryStringQueryParameters;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.query.SimilarToQueryParameters;
import com.mware.ge.query.SimilarToTextQueryParameters;
import com.mware.ge.query.SortDirection;
import com.mware.ge.query.TextPredicate;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.AggregationResult;
import com.mware.ge.scoring.ScoringStrategy;
import com.mware.ge.sorting.SortingStrategy;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.SelectManyIterable;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.TemporalValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class QueryBase
implements Query,
SimilarToGraphQuery {
    private final Graph graph;
    private final QueryParameters parameters;
    private String logicalQuery;
    private List<Aggregation> aggregations = new ArrayList<Aggregation>();

    protected QueryBase(Graph graph, String queryString, String logicalQuery, Authorizations authorizations) {
        this.graph = graph;
        this.parameters = new QueryStringQueryParameters(queryString, authorizations);
        this.logicalQuery = logicalQuery;
    }

    protected QueryBase(Graph graph, String queryString, Authorizations authorizations) {
        this.graph = graph;
        this.parameters = new QueryStringQueryParameters(queryString, authorizations);
    }

    protected QueryBase(Graph graph, String[] similarToFields, String similarToText, Authorizations authorizations) {
        this.graph = graph;
        this.parameters = new SimilarToTextQueryParameters(similarToFields, similarToText, authorizations);
    }

    public String getLogicalQuery() {
        return this.logicalQuery;
    }

    public void setLogicalQuery(String logicalQuery) {
        this.logicalQuery = logicalQuery;
    }

    @Override
    public QueryResultsIterable<Vertex> vertices() {
        return this.vertices(this.getGraph().getDefaultFetchHints());
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(FetchHints fetchHints) {
        return this.search(EnumSet.of(GeObjectType.VERTEX), fetchHints);
    }

    @Override
    public QueryResultsIterable<String> vertexIds() {
        return this.vertexIds(IdFetchHint.NONE);
    }

    @Override
    public QueryResultsIterable<String> vertexIds(EnumSet<IdFetchHint> idFetchHints) {
        FetchHints fetchHints = this.idFetchHintsToElementFetchHints(idFetchHints);
        return new DefaultGraphQueryIdIterable<String>(this.vertices(fetchHints));
    }

    @Override
    public QueryResultsIterable<Edge> edges() {
        return this.edges(this.getGraph().getDefaultFetchHints());
    }

    @Override
    public QueryResultsIterable<Edge> edges(FetchHints fetchHints) {
        return this.search(EnumSet.of(GeObjectType.EDGE), fetchHints);
    }

    @Override
    public QueryResultsIterable<String> edgeIds() {
        return this.edgeIds(IdFetchHint.NONE);
    }

    @Override
    public QueryResultsIterable<String> edgeIds(EnumSet<IdFetchHint> idFetchHints) {
        FetchHints fetchHints = this.idFetchHintsToElementFetchHints(idFetchHints);
        return new DefaultGraphQueryIdIterable<String>(this.edges(fetchHints));
    }

    @Override
    public QueryResultsIterable<ExtendedDataRow> extendedDataRows() {
        return this.extendedDataRows(this.getGraph().getDefaultFetchHints());
    }

    @Override
    public QueryResultsIterable<ExtendedDataRow> extendedDataRows(FetchHints fetchHints) {
        return this.search(EnumSet.of(GeObjectType.EXTENDED_DATA), fetchHints);
    }

    @Override
    public QueryResultsIterable<ExtendedDataRowId> extendedDataRowIds() {
        return this.extendedDataRowIds(IdFetchHint.NONE);
    }

    @Override
    public QueryResultsIterable<ExtendedDataRowId> extendedDataRowIds(EnumSet<IdFetchHint> idFetchHints) {
        FetchHints fetchHints = this.idFetchHintsToElementFetchHints(idFetchHints);
        QueryResultsIterable<? extends GeObject> geObjects = this.search(EnumSet.of(GeObjectType.EXTENDED_DATA), fetchHints);
        return new DefaultGraphQueryIdIterable<ExtendedDataRowId>(geObjects);
    }

    @Override
    public QueryResultsIterable<? extends GeObject> search() {
        return this.search(GeObjectType.ALL, this.getGraph().getDefaultFetchHints());
    }

    @Override
    public QueryResultsIterable<? extends GeObject> search(EnumSet<GeObjectType> objectTypes, FetchHints fetchHints) {
        ArrayList<QueryResultsIterable<GeObject>> items = new ArrayList<QueryResultsIterable<GeObject>>();
        if (objectTypes.contains((Object)GeObjectType.VERTEX)) {
            items.add(this.vertices(fetchHints));
        }
        if (objectTypes.contains((Object)GeObjectType.EDGE)) {
            items.add(this.edges(fetchHints));
        }
        if (objectTypes.contains((Object)GeObjectType.EXTENDED_DATA)) {
            items.add(this.extendedData(fetchHints));
        }
        if (items.size() == 1) {
            return (QueryResultsIterable)items.get(0);
        }
        return new SelectManySearch((Iterable<? extends QueryResultsIterable<? extends GeObject>>)items);
    }

    protected QueryResultsIterable<? extends GeObject> extendedData(FetchHints fetchHints) {
        throw new GeException("not implemented");
    }

    protected QueryResultsIterable<? extends GeObject> extendedData(final FetchHints fetchHints, Iterable<? extends Element> elements) {
        SelectManyIterable<Element, ExtendedDataRow> allExtendedData = new SelectManyIterable<Element, ExtendedDataRow>(elements){

            @Override
            protected Iterable<? extends ExtendedDataRow> getIterable(final Element element) {
                return new SelectManyIterable<String, ExtendedDataRow>(element.getExtendedDataTableNames()){

                    @Override
                    protected Iterable<? extends ExtendedDataRow> getIterable(String tableName) {
                        return element.getExtendedData(tableName, fetchHints);
                    }
                };
            }
        };
        return new DefaultGraphQueryIterableWithAggregations<ExtendedDataRow>(this.getParameters(), allExtendedData, true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    @Override
    public Query hasId(String ... ids) {
        this.getParameters().addIds(Arrays.asList(ids));
        return this;
    }

    @Override
    public Query hasId(Iterable<String> ids) {
        this.getParameters().addIds(IterableUtils.toList(ids));
        return this;
    }

    @Override
    public Query hasConceptType(String ... conceptTypes) {
        for (String conceptType : conceptTypes) {
            this.getParameters().addConceptType(conceptType);
        }
        return this;
    }

    @Override
    public Query hasConceptType(Collection<String> conceptTypes) {
        for (String conceptType : conceptTypes) {
            this.getParameters().addConceptType(conceptType);
        }
        return this;
    }

    @Override
    public Query hasEdgeLabel(String ... edgeLabels) {
        for (String edgeLabel : edgeLabels) {
            this.getParameters().addEdgeLabel(edgeLabel);
        }
        return this;
    }

    @Override
    public Query hasEdgeLabel(Collection<String> edgeLabels) {
        for (String edgeLabel : edgeLabels) {
            this.getParameters().addEdgeLabel(edgeLabel);
        }
        return this;
    }

    public Query hasInVertexTypes(String ... vertexTypes) {
        for (String vertexType : vertexTypes) {
            this.getParameters().addInVertexType(vertexType);
        }
        return this;
    }

    public Query hasOutVertexTypes(String ... vertexTypes) {
        for (String vertexType : vertexTypes) {
            this.getParameters().addOutVertexType(vertexType);
        }
        return this;
    }

    @Override
    public Query hasAuthorization(String ... authorizations) {
        this.getParameters().addHasContainer(new HasAuthorizationContainer(Conjunction.AND, Arrays.asList(authorizations)));
        return this;
    }

    @Override
    public Query hasAuthorization(Iterable<String> authorizations) {
        this.getParameters().addHasContainer(new HasAuthorizationContainer(Conjunction.AND, authorizations));
        return this;
    }

    @Override
    public Query hasExtendedData(ElementType elementType, String elementId) {
        return this.hasExtendedData(elementType, elementId, null);
    }

    @Override
    public Query hasExtendedData(String tableName) {
        return this.hasExtendedData(null, null, tableName);
    }

    @Override
    public Query hasExtendedData(ElementType elementType, String elementId, String tableName) {
        this.hasExtendedData(Lists.newArrayList((Object[])new HasExtendedDataFilter[]{new HasExtendedDataFilter(elementType, elementId, tableName)}));
        return this;
    }

    @Override
    public Query hasExtendedData(Iterable<HasExtendedDataFilter> filters) {
        this.getParameters().addHasContainer(new HasExtendedData(Conjunction.AND, (ImmutableList<HasExtendedDataFilter>)ImmutableList.copyOf(filters)));
        return this;
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label, FetchHints fetchHints) {
        this.hasEdgeLabel(label);
        return this.edges(fetchHints);
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label) {
        this.hasEdgeLabel(label);
        return this.edges();
    }

    @Override
    public QueryResultsIterable<Element> elements() {
        return this.elements(this.getGraph().getDefaultFetchHints());
    }

    @Override
    public QueryResultsIterable<Element> elements(FetchHints fetchHints) {
        return this.search(GeObjectType.ELEMENTS, fetchHints);
    }

    @Override
    public QueryResultsIterable<String> elementIds() {
        return this.elementIds(IdFetchHint.NONE);
    }

    @Override
    public QueryResultsIterable<String> elementIds(EnumSet<IdFetchHint> idFetchHints) {
        FetchHints fetchHints = this.idFetchHintsToElementFetchHints(idFetchHints);
        return new DefaultGraphQueryIdIterable<String>(this.elements(fetchHints));
    }

    @Override
    public <T extends Value> Query range(String propertyName, T startValue, T endValue) {
        return this.range(propertyName, startValue, true, endValue, true);
    }

    @Override
    public <T extends Value> Query range(String propertyName, T startValue, boolean inclusiveStartValue, T endValue, boolean inclusiveEndValue) {
        if (startValue != null) {
            this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyName, (Predicate)(inclusiveStartValue ? Compare.GREATER_THAN_EQUAL : Compare.GREATER_THAN), startValue, this.getGraph().getPropertyDefinitions()));
        }
        if (endValue != null) {
            this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyName, (Predicate)(inclusiveEndValue ? Compare.LESS_THAN_EQUAL : Compare.LESS_THAN), endValue, this.getGraph().getPropertyDefinitions()));
        }
        return this;
    }

    @Override
    public Query sort(String propertyName, SortDirection direction) {
        this.parameters.addSortContainer(new PropertySortContainer(propertyName, direction));
        return this;
    }

    @Override
    public Query sort(SortingStrategy sortingStrategy, SortDirection direction) {
        this.parameters.addSortContainer(new SortingStrategySortContainer(sortingStrategy, direction));
        return this;
    }

    @Override
    public <T extends Value> Query has(String propertyName, T value) {
        this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyName, (Predicate)Compare.EQUAL, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query hasNot(String propertyName, T value) {
        this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyName, (Predicate)Contains.NOT_IN, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query has(String propertyName, Predicate predicate, T value) {
        this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyName, predicate, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query has(String propertyName, Predicate predicate, Conjunction conjunction, T value) {
        this.parameters.addHasContainer(new HasValueContainer(conjunction, propertyName, predicate, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value, K extends Value> Query has(Class<T> dataType, Predicate predicate, K value) {
        this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, dataType, predicate, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query has(Class<T> dataType) {
        this.parameters.addHasContainer(new HasPropertyContainer(Conjunction.AND, dataType, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query hasNot(Class<T> dataType) {
        this.parameters.addHasContainer(new HasNotPropertyContainer(Conjunction.AND, dataType, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public <T extends Value> Query has(Iterable<String> propertyNames, Predicate predicate, T value) {
        this.parameters.addHasContainer(new HasValueContainer(Conjunction.AND, propertyNames, predicate, value, this.getGraph().getPropertyDefinitions()));
        return this;
    }

    @Override
    public Query has(String propertyName) {
        this.parameters.addHasContainer(new HasPropertyContainer(Conjunction.AND, propertyName));
        return this;
    }

    @Override
    public <T> Query has(Iterable<String> propertyNames) {
        this.parameters.addHasContainer(new HasPropertyContainer(Conjunction.AND, propertyNames));
        return this;
    }

    @Override
    public Query hasNot(String propertyName) {
        this.parameters.addHasContainer(new HasNotPropertyContainer(Conjunction.AND, propertyName));
        return this;
    }

    @Override
    public <T> Query hasNot(Iterable<String> propertyNames) {
        this.parameters.addHasContainer(new HasNotPropertyContainer(Conjunction.AND, propertyNames));
        return this;
    }

    @Override
    public Query skip(int count) {
        this.parameters.setSkip(count);
        return this;
    }

    @Override
    public Query limit(Integer count) {
        this.parameters.setLimit(count);
        return this;
    }

    @Override
    public Query limit(Long count) {
        this.parameters.setLimit(count);
        return this;
    }

    @Override
    public Query minScore(double score) {
        this.parameters.setMinScore(score);
        return this;
    }

    @Override
    public Query scoringStrategy(ScoringStrategy scoringStrategy) {
        this.parameters.setScoringStrategy(scoringStrategy);
        return this;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }

    @Override
    public SimilarToGraphQuery minTermFrequency(int minTermFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new GeException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMinTermFrequency(minTermFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery maxQueryTerms(int maxQueryTerms) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new GeException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMaxQueryTerms(maxQueryTerms);
        return this;
    }

    @Override
    public SimilarToGraphQuery minDocFrequency(int minDocFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new GeException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMinDocFrequency(minDocFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery maxDocFrequency(int maxDocFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new GeException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMaxDocFrequency(maxDocFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery boost(float boost) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new GeException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setBoost(Float.valueOf(boost));
        return this;
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        return false;
    }

    @Override
    public Query addAggregation(Aggregation aggregation) {
        if (!this.isAggregationSupported(aggregation)) {
            throw new GeException("Aggregation " + aggregation.getClass().getName() + " is not supported");
        }
        this.aggregations.add(aggregation);
        return this;
    }

    public Collection<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public Aggregation getAggregationByName(String aggregationName) {
        for (Aggregation agg : this.aggregations) {
            if (!agg.getAggregationName().equals(aggregationName)) continue;
            return agg;
        }
        return null;
    }

    protected FetchHints idFetchHintsToElementFetchHints(EnumSet<IdFetchHint> idFetchHints) {
        return idFetchHints.contains((Object)IdFetchHint.INCLUDE_HIDDEN) ? FetchHints.ALL_INCLUDING_HIDDEN : FetchHints.ALL;
    }

    @Override
    public Query setShard(String shardId) {
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "{parameters=" + this.getParameters() + '}';
    }

    public static class HasNotPropertyContainer
    extends HasContainer {
        private Set<String> keys;

        public HasNotPropertyContainer(Conjunction conjunction, String key) {
            super(conjunction);
            this.keys = Collections.singleton(key);
        }

        public HasNotPropertyContainer(Conjunction conjunction, Iterable<String> keys) {
            super(conjunction);
            this.keys = IterableUtils.toSet(keys);
        }

        public HasNotPropertyContainer(Conjunction conjunction, Class<? extends Value> dataType, Collection<PropertyDefinition> propertyDefinitions) {
            super(conjunction);
            this.keys = propertyDefinitions.stream().filter(propertyDefinition -> this.isPropertyOfType((PropertyDefinition)propertyDefinition, dataType)).map(PropertyDefinition::getPropertyName).collect(Collectors.toSet());
            if (this.keys.isEmpty()) {
                throw new GeException("Invalid query parameters, no properties of type " + dataType.getName() + " found");
            }
        }

        @Override
        public boolean isMatch(GeObject geObject) {
            for (Property prop : geObject.getProperties()) {
                if (!this.keys.contains(prop.getName())) continue;
                return false;
            }
            return true;
        }

        public Iterable<String> getKeys() {
            return ImmutableSet.copyOf(this.keys);
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{, keys='" + Joiner.on((String)", ").join(this.keys) + '\'' + '}';
        }
    }

    public static class HasPropertyContainer
    extends HasContainer {
        private Set<String> keys;

        public HasPropertyContainer(Conjunction conjunction, String key) {
            super(conjunction);
            this.keys = Collections.singleton(key);
        }

        public HasPropertyContainer(Conjunction conjunction, Iterable<String> keys) {
            super(conjunction);
            this.keys = IterableUtils.toSet(keys);
        }

        public HasPropertyContainer(Conjunction conjunction, Class<? extends Value> dataType, Collection<PropertyDefinition> propertyDefinitions) {
            super(conjunction);
            this.keys = propertyDefinitions.stream().filter(propertyDefinition -> this.isPropertyOfType((PropertyDefinition)propertyDefinition, dataType)).map(PropertyDefinition::getPropertyName).collect(Collectors.toSet());
            if (this.keys.isEmpty()) {
                throw new GeException("Invalid query parameters, no properties of type " + dataType.getName() + " found");
            }
        }

        @Override
        public boolean isMatch(GeObject geObject) {
            for (Property prop : geObject.getProperties()) {
                if (!this.keys.contains(prop.getName())) continue;
                return true;
            }
            return false;
        }

        public Iterable<String> getKeys() {
            return ImmutableSet.copyOf(this.keys);
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{, keys='" + Joiner.on((String)", ").join(this.keys) + '\'' + '}';
        }
    }

    public static class HasExtendedData
    extends HasContainer {
        private final ImmutableList<HasExtendedDataFilter> filters;

        public HasExtendedData(Conjunction conjunction, ImmutableList<HasExtendedDataFilter> filters) {
            super(conjunction);
            this.filters = filters;
        }

        public ImmutableList<HasExtendedDataFilter> getFilters() {
            return this.filters;
        }

        @Override
        public boolean isMatch(GeObject elem) {
            if (!(elem instanceof ExtendedDataRow)) {
                return false;
            }
            ExtendedDataRow row = (ExtendedDataRow)elem;
            ExtendedDataRowId rowId = row.getId();
            for (HasExtendedDataFilter filter : this.filters) {
                if (filter.getElementType() != null && (!rowId.getElementType().equals((Object)filter.getElementType()) || filter.getElementId() != null && !rowId.getElementId().equals(filter.getElementId()) || filter.getTableName() != null && !rowId.getTableName().equals(filter.getTableName()))) continue;
                return true;
            }
            return false;
        }
    }

    public static class HasValueContainer
    extends HasContainer {
        public final Set<String> keys;
        public final Value value;
        public final Predicate predicate;
        private final Collection<PropertyDefinition> propertyDefinitions;

        public HasValueContainer(Conjunction conjunction, String key, Predicate predicate, Value value, Collection<PropertyDefinition> propertyDefinitions) {
            this(conjunction, Collections.singleton(key), predicate, value, propertyDefinitions);
        }

        public HasValueContainer(Conjunction conjunction, Iterable<String> keys, Predicate predicate, Value value, Collection<PropertyDefinition> propertyDefinitions) {
            super(conjunction);
            this.keys = IterableUtils.toSet(keys);
            this.value = value;
            this.predicate = predicate;
            this.propertyDefinitions = propertyDefinitions;
            if (this.keys.isEmpty()) {
                throw new GeException("Invalid query parameters, no property names specified");
            }
            this.validateParameters();
        }

        public HasValueContainer(Conjunction conjunction, Class<? extends Value> dataType, Predicate predicate, Value value, Collection<PropertyDefinition> propertyDefinitions) {
            super(conjunction);
            this.value = value;
            this.predicate = predicate;
            this.keys = propertyDefinitions.stream().filter(propertyDefinition -> this.isPropertyOfType((PropertyDefinition)propertyDefinition, dataType)).map(PropertyDefinition::getPropertyName).collect(Collectors.toSet());
            this.propertyDefinitions = propertyDefinitions;
            if (this.keys.isEmpty()) {
                throw new GeException("Invalid query parameters, no properties of type " + dataType.getName() + " found");
            }
            this.validateParameters();
        }

        private void validateParameters() {
            this.keys.forEach(key -> {
                PropertyDefinition propertyDefinition = PropertyDefinition.findPropertyDefinition(this.propertyDefinitions, key);
                if (this.predicate instanceof TextPredicate && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.FULL_TEXT)) {
                    throw new GeException("Check your TextIndexHint settings. Property " + propertyDefinition.getPropertyName() + " is not full text indexed.");
                }
                if (this.predicate instanceof GeoCompare && !this.isPropertyOfType(propertyDefinition, GeoShapeValue.class)) {
                    throw new GeException("GeoCompare query is only allowed for GeoShape types. Property " + propertyDefinition.getPropertyName() + " is not a GeoShape.");
                }
                if (Compare.STARTS_WITH.equals(this.predicate) && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.EXACT_MATCH)) {
                    throw new GeException("Check your TextIndexHint settings. Property " + propertyDefinition.getPropertyName() + " is not exact match indexed.");
                }
            });
        }

        @Override
        public boolean isMatch(GeObject geObject) {
            for (String key : this.keys) {
                if (!this.predicate.evaluate(geObject.getProperties(key), (Object)this.value, this.propertyDefinitions)) continue;
                return true;
            }
            return false;
        }

        public Iterable<String> getKeys() {
            return ImmutableSet.copyOf(this.keys);
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{predicate=" + this.predicate + ", value=" + this.value + ", keys='" + Joiner.on((String)", ").join(this.keys) + '\'' + '}';
        }
    }

    public static class HasAuthorizationContainer
    extends HasContainer {
        public final Set<String> authorizations;

        public HasAuthorizationContainer(Conjunction conjunction, Iterable<String> authorizations) {
            super(conjunction);
            this.authorizations = IterableUtils.toSet(authorizations);
        }

        @Override
        public boolean isMatch(GeObject geObject) {
            for (String authorization : this.authorizations) {
                boolean propertyMatches;
                if (geObject instanceof Element) {
                    Element element = (Element)geObject;
                    if (element.getVisibility().hasAuthorization(authorization)) {
                        return true;
                    }
                    boolean hiddenVisibilityMatches = StreamUtils.stream(element.getHiddenVisibilities()).anyMatch(visibility -> visibility.hasAuthorization(authorization));
                    if (hiddenVisibilityMatches) {
                        return true;
                    }
                }
                if (!(propertyMatches = StreamUtils.stream(geObject.getProperties()).anyMatch(property -> {
                    if (property.getVisibility().hasAuthorization(authorization)) {
                        return true;
                    }
                    return StreamUtils.stream(property.getHiddenVisibilities()).anyMatch(visibility -> visibility.hasAuthorization(authorization));
                }))) continue;
                return true;
            }
            return false;
        }

        public Iterable<String> getAuthorizations() {
            return this.authorizations;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{, authorizations='" + Joiner.on((String)", ").join(this.authorizations) + '\'' + '}';
        }
    }

    public static class SortingStrategySortContainer
    implements SortContainer {
        public final SortingStrategy sortingStrategy;
        public final SortDirection direction;

        public SortingStrategySortContainer(SortingStrategy sortingStrategy, SortDirection direction) {
            this.sortingStrategy = sortingStrategy;
            this.direction = direction;
        }

        public String toString() {
            return "SortingStrategySortContainer{sortingStrategy=" + this.sortingStrategy + ", direction=" + (Object)((Object)this.direction) + '}';
        }
    }

    public static class PropertySortContainer
    implements SortContainer {
        public final String propertyName;
        public final SortDirection direction;

        public PropertySortContainer(String propertyName, SortDirection direction) {
            this.propertyName = propertyName;
            this.direction = direction;
        }

        public String toString() {
            return this.getClass().getName() + "{propertyName='" + this.propertyName + '\'' + ", direction=" + (Object)((Object)this.direction) + '}';
        }
    }

    public static interface SortContainer {
    }

    public static abstract class HasContainer {
        public final Conjunction conjunction;

        public HasContainer(Conjunction conjunction) {
            this.conjunction = conjunction;
        }

        public abstract boolean isMatch(GeObject var1);

        public String toString() {
            return this.getClass().getName() + "{}";
        }

        protected boolean isPropertyOfType(PropertyDefinition propertyDefinition, Class<? extends Value> dataType) {
            boolean propertyIsDate = TemporalValue.class.isAssignableFrom(propertyDefinition.getDataType());
            boolean dataTypeIsDate = TemporalValue.class.isAssignableFrom(dataType);
            return dataType.isAssignableFrom(propertyDefinition.getDataType()) || propertyIsDate && dataTypeIsDate;
        }
    }

    private static class SelectManySearch
    extends SelectManyIterable<QueryResultsIterable<? extends GeObject>, GeObject>
    implements QueryResultsIterable<GeObject> {
        public SelectManySearch(Iterable<? extends QueryResultsIterable<? extends GeObject>> source) {
            super(source);
        }

        @Override
        public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
            throw new GeException("Not implemented");
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long getTotalHits() {
            long totalHits = 0L;
            for (QueryResultsIterable queryResultsIterable : this.getSource()) {
                totalHits += queryResultsIterable.getTotalHits();
            }
            return totalHits;
        }

        @Override
        protected Iterable<? extends GeObject> getIterable(QueryResultsIterable<? extends GeObject> source) {
            return source;
        }
    }
}

