/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.google.common.base.Joiner;
import com.mware.ge.Authorizations;
import com.mware.ge.query.QueryBase;
import com.mware.ge.scoring.ScoringStrategy;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class QueryParameters
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(QueryParameters.class);
    public static final int DEFAULT_SKIP = 0;
    private Double minScore = null;
    private final Authorizations authorizations;
    private Long limit = null;
    private long skip = 0L;
    private final List<QueryBase.HasContainer> hasContainers = new ArrayList<QueryBase.HasContainer>();
    private final List<QueryBase.SortContainer> sortContainers = new ArrayList<QueryBase.SortContainer>();
    private final List<String> edgeLabels = new ArrayList<String>();
    private final List<String> conceptTypes = new ArrayList<String>();
    private final List<String> inVertexTypes = new ArrayList<String>();
    private final List<String> outVertexTypes = new ArrayList<String>();
    private List<String> ids;
    private ScoringStrategy scoringStrategy;

    public QueryParameters(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    public void addHasContainer(QueryBase.HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit == null ? null : Long.valueOf(limit.intValue());
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public long getSkip() {
        return this.skip;
    }

    public void setSkip(long skip) {
        this.skip = skip;
    }

    public Double getMinScore() {
        return this.minScore;
    }

    public void setMinScore(Double minScore) {
        this.minScore = minScore;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public List<QueryBase.HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    public List<QueryBase.SortContainer> getSortContainers() {
        return this.sortContainers;
    }

    public void addSortContainer(QueryBase.SortContainer sortContainer) {
        this.sortContainers.add(sortContainer);
    }

    public List<String> getEdgeLabels() {
        return this.edgeLabels;
    }

    public List<String> getConceptTypes() {
        return this.conceptTypes;
    }

    public List<String> getOutVertexTypes() {
        return this.outVertexTypes;
    }

    public void addOutVertexType(String outVertexType) {
        this.inVertexTypes.add(outVertexType);
    }

    public void addEdgeLabel(String edgeLabel) {
        this.edgeLabels.add(edgeLabel);
    }

    public void addConceptType(String conceptType) {
        this.conceptTypes.add(conceptType);
    }

    public List<String> getInVertexTypes() {
        return this.inVertexTypes;
    }

    public void addInVertexType(String inVertexType) {
        this.inVertexTypes.add(inVertexType);
    }

    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    public void setScoringStrategy(ScoringStrategy scoringStrategy) {
        this.scoringStrategy = scoringStrategy;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void addIds(Collection<String> ids) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>(ids);
        } else {
            this.ids.retainAll(ids);
            if (this.ids.isEmpty()) {
                LOGGER.warn("No ids remain after addIds. All elements will be filtered out.", new Object[0]);
            }
        }
    }

    public abstract QueryParameters clone();

    protected QueryParameters cloneTo(QueryParameters result) {
        result.setSkip(this.getSkip());
        result.setLimit(this.getLimit());
        result.setMinScore(this.getMinScore());
        result.setScoringStrategy(this.getScoringStrategy());
        result.hasContainers.addAll(this.getHasContainers());
        result.sortContainers.addAll(this.getSortContainers());
        result.edgeLabels.addAll(this.getEdgeLabels());
        result.ids = this.ids == null ? null : new ArrayList<String>(this.ids);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "{authorizations=" + this.authorizations + ", limit=" + this.limit + ", skip=" + this.skip + ", hasContainers=" + Joiner.on((String)", ").join(this.hasContainers) + ", sortContainers=" + Joiner.on((String)", ").join(this.sortContainers) + ", edgeLabels=" + Joiner.on((String)", ").join(this.edgeLabels) + ", ids=" + (this.ids == null ? null : Joiner.on((String)", ").join(this.ids)) + ", scoring=" + (this.scoringStrategy == null ? "null" : this.scoringStrategy.getClass().getName()) + '}';
    }
}

