/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.query.QueryBase;
import com.mware.ge.query.SortDirection;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Comparator;
import java.util.List;

public class SortContainersComparator<T>
implements Comparator<T> {
    private final List<QueryBase.SortContainer> sortContainers;

    public SortContainersComparator(List<QueryBase.SortContainer> sortContainers) {
        this.sortContainers = sortContainers;
    }

    @Override
    public int compare(T elem1, T elem2) {
        for (QueryBase.SortContainer sortContainer : this.sortContainers) {
            int result = this.compare(sortContainer, elem1, elem2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(QueryBase.SortContainer sortContainer, T geObject1, T geObject2) {
        if (geObject1 instanceof GeObject && geObject2 instanceof GeObject) {
            GeObject elem1 = (GeObject)geObject1;
            GeObject elem2 = (GeObject)geObject2;
            if (sortContainer instanceof QueryBase.PropertySortContainer) {
                return this.compareProperty((QueryBase.PropertySortContainer)sortContainer, elem1, elem2);
            }
            if (sortContainer instanceof QueryBase.SortingStrategySortContainer) {
                return this.compareSortingStrategy((QueryBase.SortingStrategySortContainer)sortContainer, elem1, elem2);
            }
            throw new GeException("Unexpected sort container type: " + sortContainer.getClass().getName());
        }
        throw new GeException("unexpected searchable item combination: " + geObject1.getClass().getName() + ", " + geObject2.getClass().getName());
    }

    private int compareSortingStrategy(QueryBase.SortingStrategySortContainer sortContainer, GeObject elem1, GeObject elem2) {
        return sortContainer.sortingStrategy.compare(elem1, elem2, sortContainer.direction);
    }

    private int compareProperty(QueryBase.PropertySortContainer sortContainer, GeObject elem1, GeObject elem2) {
        List<Value> elem1PropertyValues = IterableUtils.toList(elem1.getPropertyValues(sortContainer.propertyName));
        List<Value> elem2PropertyValues = IterableUtils.toList(elem2.getPropertyValues(sortContainer.propertyName));
        if (elem1PropertyValues.size() > 0 && elem2PropertyValues.size() == 0) {
            return -1;
        }
        if (elem2PropertyValues.size() > 0 && elem1PropertyValues.size() == 0) {
            return 1;
        }
        for (Value elem1PropertyValue : elem1PropertyValues) {
            for (Value elem2PropertyValue : elem2PropertyValues) {
                int result = this.comparePropertyValues(elem1PropertyValue, elem2PropertyValue);
                if (result == 0) continue;
                return sortContainer.direction == SortDirection.ASCENDING ? result : -result;
            }
        }
        return 0;
    }

    private int comparePropertyValues(Object v1, Object v2) {
        if (v1 instanceof Value && v2 instanceof Value) {
            return Values.COMPARATOR.compare((Value)v1, (Value)v2);
        }
        if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
            return ((Comparable)v1).compareTo(v2);
        }
        return 0;
    }
}

