/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.TextIndexHint;
import com.mware.ge.query.Predicate;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public enum TextPredicate implements Predicate
{
    CONTAINS,
    DOES_NOT_CONTAIN;


    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Collection<PropertyDefinition> propertyDefinitions) {
        if (IterableUtils.count(properties) == 0 && this == DOES_NOT_CONTAIN) {
            return true;
        }
        for (Property property : properties) {
            PropertyDefinition propertyDefinition = PropertyDefinition.findPropertyDefinition(propertyDefinitions, property.getName());
            if (!this.evaluate(property.getValue(), second, propertyDefinition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(Object first, Object second, PropertyDefinition propertyDefinition) {
        if (!this.canEvaulate(first) || !this.canEvaulate(second)) {
            throw new GeException("Text predicates are only valid for string or GeoPoint fields");
        }
        String firstString = this.valueToString(first);
        String secondString = this.valueToString(second);
        switch (this) {
            case CONTAINS: {
                if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.FULL_TEXT)) {
                    return false;
                }
                return firstString.contains(secondString);
            }
            case DOES_NOT_CONTAIN: {
                if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.FULL_TEXT)) {
                    return true;
                }
                String[] tokenizedString = firstString.split("\\W+");
                return !Arrays.asList(tokenizedString).contains(secondString);
            }
        }
        throw new IllegalArgumentException("Invalid text predicate: " + this);
    }

    @Override
    public void validate(PropertyDefinition propertyDefinition) {
        Set<TextIndexHint> textIndexHints = propertyDefinition.getTextIndexHints();
        if (textIndexHints == null || !textIndexHints.contains((Object)TextIndexHint.FULL_TEXT)) {
            throw new GeException("Check your TextIndexHint settings. Property " + propertyDefinition.getPropertyName() + " is not full text indexed.");
        }
    }

    private String valueToString(Object val) {
        if (val instanceof StreamingPropertyValue) {
            return ((StreamingPropertyValue)val).readToString().toLowerCase();
        }
        return ((TextValue)val).toLower().stringValue();
    }

    private boolean canEvaulate(Object first) {
        if (first instanceof TextValue) {
            return true;
        }
        if (first instanceof GeoPointValue) {
            return true;
        }
        return first instanceof StreamingPropertyValue && TextValue.class.isAssignableFrom(((StreamingPropertyValue)first).getValueType());
    }
}

