/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query.aggregations;

import com.mware.ge.GeException;
import com.mware.ge.query.aggregations.CardinalityResult;
import com.mware.ge.query.aggregations.GeohashBucket;
import com.mware.ge.query.aggregations.GeohashResult;
import com.mware.ge.query.aggregations.HistogramBucket;
import com.mware.ge.query.aggregations.HistogramResult;
import com.mware.ge.query.aggregations.RangeBucket;
import com.mware.ge.query.aggregations.RangeResult;
import com.mware.ge.query.aggregations.StatisticsResult;
import com.mware.ge.query.aggregations.TermsBucket;
import com.mware.ge.query.aggregations.TermsResult;
import java.util.ArrayList;

public abstract class AggregationResult {
    protected boolean orderedByNestedAgg = false;

    public static <TResult extends AggregationResult> TResult createEmptyResult(Class<? extends TResult> resultType) {
        if (resultType.equals(TermsResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new TermsResult(new ArrayList<TermsBucket>())));
        }
        if (resultType.equals(StatisticsResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new StatisticsResult(0L, 0.0, 0.0, 0.0, 0.0)));
        }
        if (resultType.equals(HistogramResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new HistogramResult(new ArrayList<HistogramBucket>())));
        }
        if (resultType.equals(RangeResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new RangeResult(new ArrayList<RangeBucket>())));
        }
        if (resultType.equals(GeohashResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new GeohashResult(new ArrayList<GeohashBucket>())));
        }
        if (resultType.equals(CardinalityResult.class)) {
            return (TResult)((AggregationResult)resultType.cast(new CardinalityResult(0L)));
        }
        throw new GeException("Unhandled type to create empty results for: " + resultType.getName());
    }

    public boolean isOrderedByNestedAgg() {
        return this.orderedByNestedAgg;
    }

    public void setOrderedByNestedAgg(boolean orderedByNestedAgg) {
        this.orderedByNestedAgg = orderedByNestedAgg;
    }
}

