/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query.aggregations;

import com.mware.ge.GeException;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.SupportsNestedAggregationsAggregation;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HistogramAggregation
extends Aggregation
implements SupportsNestedAggregationsAggregation {
    private final String aggregationName;
    private final String fieldName;
    private final String interval;
    private final Long minDocumentCount;
    private Value missingValue;
    private final List<Aggregation> nestedAggregations = new ArrayList<Aggregation>();
    private ExtendedBounds<?> extendedBounds;

    public HistogramAggregation(String aggregationName, String fieldName, String interval, Long minDocumentCount) {
        this.aggregationName = aggregationName;
        this.fieldName = fieldName;
        this.interval = interval;
        this.minDocumentCount = minDocumentCount;
    }

    @Override
    public String getAggregationName() {
        return this.aggregationName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getInterval() {
        return this.interval;
    }

    public Long getMinDocumentCount() {
        return this.minDocumentCount;
    }

    public void setMissingValue(Value missingValue) {
        this.missingValue = missingValue;
    }

    public Value getMissingValue() {
        return this.missingValue;
    }

    @Override
    public void addNestedAggregation(Aggregation nestedAggregation) {
        this.nestedAggregations.add(nestedAggregation);
    }

    @Override
    public Iterable<Aggregation> getNestedAggregations() {
        return this.nestedAggregations;
    }

    public ExtendedBounds<?> getExtendedBounds() {
        return this.extendedBounds;
    }

    public void setExtendedBounds(ExtendedBounds<?> extendedBounds) {
        this.extendedBounds = extendedBounds;
    }

    public static class ExtendedBounds<T extends Value>
    implements Serializable {
        private static final long serialVersionUID = 6441762717687378245L;
        private final T min;
        private final T max;

        public ExtendedBounds(T min, T max) {
            if (min == null && max == null) {
                throw new GeException("Either min or max needs to not be null");
            }
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }

        public Class<? extends Value> getMinMaxType() {
            if (this.min != null) {
                return this.min.getClass();
            }
            if (this.max != null) {
                return this.max.getClass();
            }
            throw new GeException("Invalid state. min or max must not be null.");
        }
    }
}

