/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query.aggregations;

import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.SupportsNestedAggregationsAggregation;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.List;

public class RangeAggregation
extends Aggregation
implements SupportsNestedAggregationsAggregation {
    private final String aggregationName;
    private final String fieldName;
    private String format;
    private List<Range> ranges = new ArrayList<Range>();
    private final List<Aggregation> nestedAggregations = new ArrayList<Aggregation>();

    public RangeAggregation(String aggregationName, String fieldName) {
        this.aggregationName = aggregationName;
        this.fieldName = fieldName;
    }

    public RangeAggregation(String aggregationName, String fieldName, String format) {
        this(aggregationName, fieldName);
        this.format = format;
    }

    @Override
    public String getAggregationName() {
        return this.aggregationName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void addNestedAggregation(Aggregation nestedAggregation) {
        this.nestedAggregations.add(nestedAggregation);
    }

    @Override
    public Iterable<Aggregation> getNestedAggregations() {
        return this.nestedAggregations;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void addRange(Value from, Value to) {
        this.addRange(null, from, to);
    }

    public void addRange(String key, Value from, Value to) {
        this.ranges.add(new Range(key, from, to));
    }

    public void addUnboundedTo(Value to) {
        this.addRange(null, null, to);
    }

    public void addUnboundedTo(String key, Value to) {
        this.addRange(key, null, to);
    }

    public void addUnboundedFrom(Value from) {
        this.addRange(null, from, null);
    }

    public void addUnboundedFrom(String key, Value from) {
        this.addRange(key, from, null);
    }

    public class Range {
        private String key;
        private Value from;
        private Value to;

        public Range(String key, Value from, Value to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        public String getKey() {
            return this.key;
        }

        public Value getFrom() {
            return this.from;
        }

        public Value getTo() {
            return this.to;
        }
    }
}

