/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.scoring;

import com.mware.ge.GeObject;
import com.mware.ge.scoring.ScoringStrategy;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.math.BigInteger;

public class HammingDistanceScoringStrategy
implements ScoringStrategy {
    private final String hash;
    private final String field;

    public HammingDistanceScoringStrategy(String field, String hash) {
        this.field = field;
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public Double getScore(GeObject geObject) {
        double score = 0.0;
        Iterable<Value> values = geObject.getPropertyValues(this.getField());
        for (Value value : values) {
            if (!(value instanceof TextValue)) continue;
            String valueStr = ((TextValue)value).stringValue();
            int maxLen = Math.min(valueStr.length(), this.hash.length()) * 4;
            score = Math.max(score, (double)(maxLen - new BigInteger(valueStr, 16).xor(new BigInteger(this.hash, 16)).bitCount()));
        }
        return score;
    }
}

