/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.search;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ElementLocation;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.GeNotSupportedException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.Property;
import com.mware.ge.SearchIndexSecurityGranularity;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.property.PropertyDescriptor;
import com.mware.ge.query.DefaultExtendedDataQuery;
import com.mware.ge.query.DefaultGraphQuery;
import com.mware.ge.query.DefaultMultiVertexQuery;
import com.mware.ge.query.DefaultVertexQuery;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.MultiVertexQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.query.VertexQuery;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.util.Preconditions;

public class DefaultSearchIndex
implements SearchIndex {
    public DefaultSearchIndex(GraphConfiguration configuration) {
    }

    @Override
    public void addElement(Graph graph, Element element, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public <TElement extends Element> void updateElement(Graph graph, ExistingElementMutation<TElement> mutation, Authorizations authorizations) {
        Preconditions.checkNotNull(mutation, "mutation cannot be null");
    }

    @Override
    public void markElementHidden(Graph graph, Element element, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
    }

    @Override
    public void markElementVisible(Graph graph, ElementLocation elementLocation, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(elementLocation, "elementLocation cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
    }

    @Override
    public void markPropertyHidden(Graph graph, ElementLocation elementLocation, Property property, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(elementLocation, "elementLocation cannot be null");
        Preconditions.checkNotNull(property, "property cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
    }

    @Override
    public void markPropertyVisible(Graph graph, ElementLocation elementLocation, Property property, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(elementLocation, "elementLocation cannot be null");
        Preconditions.checkNotNull(property, "property cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
    }

    @Override
    public <T extends Element> void alterElementVisibility(Graph graph, ExistingElementMutation<T> elementMutation, Visibility oldVisibility, Visibility newVisibility, Authorizations authorizations) {
        Preconditions.checkNotNull(elementMutation, "elementMutation cannot be null");
        Preconditions.checkNotNull(newVisibility, "newVisibility cannot be null");
    }

    @Override
    public void deleteElement(Graph graph, ElementId element, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public void deleteElements(Graph graph, Iterable<? extends ElementId> elementIds, Authorizations authorizations) {
        Preconditions.checkNotNull(elementIds, "element cannot be null");
    }

    @Override
    public void deleteProperty(Graph graph, Element element, PropertyDescriptor property, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        for (Element element : elements) {
            this.addElement(graph, element, authorizations);
        }
    }

    @Override
    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new DefaultGraphQuery(graph, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery queryGraph(Graph graph, String[] vertexIds, String queryString, Authorizations authorizations) {
        return new DefaultMultiVertexQuery(graph, vertexIds, queryString, authorizations);
    }

    @Override
    public VertexQuery queryVertex(Graph graph, Vertex vertex, String queryString, Authorizations authorizations) {
        return new DefaultVertexQuery(graph, vertex, queryString, authorizations);
    }

    @Override
    public void flush(Graph graph) {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isFieldBoostSupported() {
        return false;
    }

    @Override
    public void truncate(Graph graph) {
    }

    @Override
    public void drop(Graph graph) {
    }

    @Override
    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.PROPERTY;
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return false;
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] fields, String text, Authorizations authorizations) {
        throw new GeNotSupportedException("querySimilarTo not supported");
    }

    @Override
    public boolean isFieldLevelSecuritySupported() {
        return true;
    }

    @Override
    public void addElementExtendedData(Graph graph, ElementLocation elementLocation, Iterable<ExtendedDataMutation> extendedDatas, Authorizations authorizations) {
    }

    @Override
    public void addExtendedData(Graph graph, ElementLocation elementLocation, Iterable<ExtendedDataRow> extendedDatas, Authorizations authorizations) {
    }

    @Override
    public void deleteExtendedData(Graph graph, ExtendedDataRowId extendedDataRowId, Authorizations authorizations) {
        Preconditions.checkNotNull(extendedDataRowId, "extendedDataRowId cannot be null");
    }

    @Override
    public Query queryExtendedData(Graph graph, Element element, String tableName, String queryString, Authorizations authorizations) {
        return new DefaultExtendedDataQuery(graph, element, tableName, queryString, authorizations);
    }

    @Override
    public void deleteExtendedData(Graph graph, ElementLocation elementLocation, String tableName, String row, String columnName, String key, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(elementLocation, "elementLocation cannot be null");
        Preconditions.checkNotNull(tableName, "tableName cannot be null");
        Preconditions.checkNotNull(row, "row cannot be null");
        Preconditions.checkNotNull(columnName, "columnName cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
    }

    @Override
    public void enableBulkIngest(boolean enable) {
    }

    @Override
    public int getNumShards() {
        return 1;
    }
}

