/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.search;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ElementLocation;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.Graph;
import com.mware.ge.Property;
import com.mware.ge.SearchIndexSecurityGranularity;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.property.PropertyDescriptor;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.MultiVertexQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.query.VertexQuery;
import java.util.Collection;

public interface SearchIndex {
    public static final String EDGE_LABEL_FIELD_NAME = "__edgeLabel";
    public static final String CONCEPT_TYPE_FIELD_NAME = "__conceptType";

    public void addElement(Graph var1, Element var2, Authorizations var3);

    public <TElement extends Element> void updateElement(Graph var1, ExistingElementMutation<TElement> var2, Authorizations var3);

    public void deleteElement(Graph var1, ElementId var2, Authorizations var3);

    default public void deleteElements(Graph graph, Iterable<? extends ElementId> elementIds, Authorizations authorizations) {
        for (ElementId elementId : elementIds) {
            this.deleteElement(graph, elementId, authorizations);
        }
    }

    public void markElementHidden(Graph var1, Element var2, Visibility var3, Authorizations var4);

    public void markElementVisible(Graph var1, ElementLocation var2, Visibility var3, Authorizations var4);

    public void markPropertyHidden(Graph var1, ElementLocation var2, Property var3, Visibility var4, Authorizations var5);

    public void markPropertyVisible(Graph var1, ElementLocation var2, Property var3, Visibility var4, Authorizations var5);

    default public void deleteProperties(Graph graph, Element element, Collection<PropertyDescriptor> propertyList, Authorizations authorizations) {
        propertyList.forEach(p -> this.deleteProperty(graph, element, (PropertyDescriptor)p, authorizations));
    }

    public void deleteProperty(Graph var1, Element var2, PropertyDescriptor var3, Authorizations var4);

    public void addElements(Graph var1, Iterable<? extends Element> var2, Authorizations var3);

    public GraphQuery queryGraph(Graph var1, String var2, Authorizations var3);

    public MultiVertexQuery queryGraph(Graph var1, String[] var2, String var3, Authorizations var4);

    public VertexQuery queryVertex(Graph var1, Vertex var2, String var3, Authorizations var4);

    public Query queryExtendedData(Graph var1, Element var2, String var3, String var4, Authorizations var5);

    public SimilarToGraphQuery querySimilarTo(Graph var1, String[] var2, String var3, Authorizations var4);

    public void flush(Graph var1);

    public void shutdown();

    public void clearCache();

    public boolean isFieldBoostSupported();

    public void truncate(Graph var1);

    public void drop(Graph var1);

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public boolean isQuerySimilarToTextSupported();

    public boolean isFieldLevelSecuritySupported();

    public <T extends Element> void alterElementVisibility(Graph var1, ExistingElementMutation<T> var2, Visibility var3, Visibility var4, Authorizations var5);

    public void addElementExtendedData(Graph var1, ElementLocation var2, Iterable<ExtendedDataMutation> var3, Authorizations var4);

    public void addExtendedData(Graph var1, ElementLocation var2, Iterable<ExtendedDataRow> var3, Authorizations var4);

    public void deleteExtendedData(Graph var1, ExtendedDataRowId var2, Authorizations var3);

    public void deleteExtendedData(Graph var1, ElementLocation var2, String var3, String var4, String var5, String var6, Visibility var7, Authorizations var8);

    public void enableBulkIngest(boolean var1);

    public int getNumShards();
}

