/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo;

import com.mware.ge.EdgesSummary;
import com.mware.ge.GeException;
import com.mware.ge.serializer.kryo.customserializers.EdgesSummarySerializer;
import com.mware.ge.serializer.kryo.customserializers.GuavaSerializers;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.kryo.kryo.Kryo;
import com.mware.kryo.kryo.serializers.FieldSerializerConfig;
import com.mware.kryo.kryo.util.DefaultClassResolver;
import com.mware.kryo.kryo.util.MapReferenceResolver;
import com.mware.objenesis.strategy.StdInstantiatorStrategy;
import java.util.Date;
import java.util.HashMap;

public class KryoFactory {
    public Kryo createKryo() {
        Kryo kryo = new Kryo(new DefaultClassResolver(), new MapReferenceResolver(){

            @Override
            public boolean useReferences(Class type) {
                if (type == String.class || type == Date.class) {
                    return false;
                }
                return super.useReferences(type);
            }
        });
        this.registerClasses(kryo);
        kryo.setAutoReset(true);
        FieldSerializerConfig fieldSerializerConfig = kryo.getFieldSerializerConfig();
        fieldSerializerConfig.setIgnoreSyntheticFields(false);
        kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        return kryo;
    }

    private void registerClasses(Kryo kryo) {
        kryo.register(StorableEdgeInfo.class, 1000);
        kryo.register(HashMap.class, 1002);
        kryo.register(StreamingPropertyValueRef.class, 1003);
        this.registerAccumuloClasses(kryo);
        kryo.register(EdgesSummary.class, new EdgesSummarySerializer(), 1013);
        this.registerGuavaImmutableClasses(kryo);
    }

    private void registerGuavaImmutableClasses(Kryo kryo) {
        GuavaSerializers.register(kryo);
    }

    private void registerAccumuloClasses(Kryo kryo) {
        try {
            Class.forName("com.mware.ge.accumulo.AccumuloGraph");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            kryo.register(Class.forName("com.mware.ge.accumulo.StreamingPropertyValueTableRef"), 1004);
            kryo.register(Class.forName("com.mware.ge.accumulo.StreamingPropertyValueHdfsRef"), 1005);
        }
        catch (ClassNotFoundException ex) {
            throw new GeException("Could not find accumulo classes to serialize", ex);
        }
    }
}

