/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.customserializers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mware.ge.serializer.kryo.customserializers.ImmutableListSerializer;
import com.mware.ge.serializer.kryo.customserializers.ImmutableMapSerializer;
import com.mware.ge.serializer.kryo.customserializers.ImmutableSetSerializer;
import com.mware.ge.serializer.kryo.customserializers.Value;
import com.mware.kryo.kryo.Kryo;
import java.util.EnumMap;

public class GuavaSerializers {
    public static void register(Kryo kryo) {
        GuavaSerializers.registerImmutableListSerializers(kryo);
        GuavaSerializers.registerImmutableSetSerializers(kryo);
        GuavaSerializers.registerImmutableMapSerializers(kryo);
    }

    private static void registerImmutableListSerializers(Kryo kryo) {
        ImmutableListSerializer serializer = new ImmutableListSerializer();
        kryo.register(ImmutableList.class, serializer);
        kryo.register(ImmutableList.of().getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1).getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4).subList(1, 3).getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1, (Object)2).reverse().getClass(), serializer);
        kryo.register(Lists.charactersOf((String)"KryoRocks").getClass(), serializer);
        HashBasedTable baseTable = HashBasedTable.create();
        baseTable.put((Object)1, (Object)2, (Object)3);
        baseTable.put((Object)4, (Object)5, (Object)6);
        ImmutableTable table = ImmutableTable.copyOf((Table)baseTable);
        kryo.register(table.values().getClass(), serializer);
    }

    private static void registerImmutableSetSerializers(Kryo kryo) {
        ImmutableSetSerializer serializer = new ImmutableSetSerializer();
        kryo.register(ImmutableSet.class, serializer);
        kryo.register(ImmutableSet.of().getClass(), serializer);
        kryo.register(ImmutableSet.of((Object)1).getClass(), serializer);
        kryo.register(ImmutableSet.of((Object)1, (Object)2, (Object)3).getClass(), serializer);
        kryo.register(Sets.immutableEnumSet((Enum)Value.VALUE1, (Enum[])new Value[]{Value.VALUE2, Value.VALUE3}).getClass(), serializer);
    }

    private static void registerImmutableMapSerializers(Kryo kryo) {
        ImmutableMapSerializer serializer = new ImmutableMapSerializer();
        kryo.register(ImmutableMap.class, serializer);
        kryo.register(ImmutableMap.of().getClass(), serializer);
        Object o1 = new Object();
        Object o2 = new Object();
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1).getClass(), serializer);
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1, (Object)o2, (Object)o2).getClass(), serializer);
        EnumMap<Value, Object> enumMap = new EnumMap<Value, Object>(Value.class);
        for (Value e : Value.values()) {
            enumMap.put(e, o1);
        }
        kryo.register(ImmutableMap.copyOf(enumMap).getClass(), serializer);
    }
}

