/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.customserializers;

import com.google.common.collect.ImmutableList;
import com.mware.kryo.kryo.Kryo;
import com.mware.kryo.kryo.Serializer;
import com.mware.kryo.kryo.io.Input;
import com.mware.kryo.kryo.io.Output;

public class ImmutableListSerializer
extends Serializer<ImmutableList> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableListSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableList object) {
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    @Override
    public ImmutableList<Object> read(Kryo kryo, Input input, Class<ImmutableList> type) {
        int size = input.readInt(true);
        Object[] list = new Object[size];
        for (int i = 0; i < size; ++i) {
            list[i] = kryo.readClassAndObject(input);
        }
        return ImmutableList.copyOf((Object[])list);
    }
}

