/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.customserializers;

import com.google.common.collect.ImmutableSet;
import com.mware.kryo.kryo.Kryo;
import com.mware.kryo.kryo.Serializer;
import com.mware.kryo.kryo.io.Input;
import com.mware.kryo.kryo.io.Output;

public class ImmutableSetSerializer
extends Serializer<ImmutableSet> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableSetSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableSet object) {
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    @Override
    public ImmutableSet<Object> read(Kryo kryo, Input input, Class<ImmutableSet> type) {
        int size = input.readInt(true);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(kryo.readClassAndObject(input));
        }
        return builder.build();
    }
}

