/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.BooleanArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class BooleanArraySerializer
implements QuickTypeSerializer<BooleanArray> {
    BooleanArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(BooleanArray value) {
        boolean[] array;
        ByteBuffer buf = ByteBuffer.allocate(1 + value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)2);
        for (boolean b : array = value.asObjectCopy()) {
            buf.put(b ? (byte)1 : 0);
        }
        return buf.array();
    }

    @Override
    public BooleanArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        boolean[] dest = new boolean[buffer.remaining()];
        for (int i = buffer.position(); i <= buffer.remaining(); ++i) {
            byte v = buffer.get(i);
            dest[i - 1] = v == 1;
        }
        return Values.booleanArray(dest);
    }
}

