/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.BooleanValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class BooleanValueSerializer
implements QuickTypeSerializer<BooleanValue> {
    BooleanValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(BooleanValue value) {
        return ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).put((byte)1).put(value.booleanValue() ? (byte)1 : 0).array();
    }

    @Override
    public BooleanValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.get();
        byte v = buffer.get();
        return v == 1 ? BooleanValue.TRUE : BooleanValue.FALSE;
    }
}

