/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class ByteArraySerializer
implements QuickTypeSerializer<ByteArray> {
    ByteArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(ByteArray value) {
        return ByteBuffer.allocate(1 + value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)4).put(value.asObjectCopy()).array();
    }

    @Override
    public ByteArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        byte[] dest = new byte[buffer.remaining()];
        buffer.get(dest);
        return Values.byteArray(dest);
    }
}

