/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.CharArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

class CharArraySerializer
implements QuickTypeSerializer<CharArray> {
    CharArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(CharArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 2 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)6);
        buf.asCharBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    @Override
    public CharArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        CharBuffer charBuffer = buffer.asCharBuffer();
        char[] dest = new char[charBuffer.remaining()];
        charBuffer.get(dest);
        return Values.charArray(dest);
    }
}

