/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.DateArray;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;

class DateArraySerializer
implements QuickTypeSerializer<DateArray> {
    DateArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(DateArray value) {
        LocalDate[] v = (LocalDate[])value.asObjectCopy();
        int arrLength = v.length;
        ByteBuffer buf = ByteBuffer.allocate(5 + 8 * arrLength).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)7);
        buf.putInt(arrLength);
        for (int i = 0; i < value.length(); ++i) {
            buf.putLong(v[i].toEpochDay());
        }
        return buf.array();
    }

    @Override
    public DateArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrLength = buffer.getInt();
        LocalDate[] arr = new LocalDate[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            arr[i] = DateValue.epochDateRaw(buffer.getLong());
        }
        return Values.dateArray(arr);
    }
}

