/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.DateTimeValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.DateTimeArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZonedDateTime;

class DateTimeArraySerializer
implements QuickTypeSerializer<DateTimeArray> {
    DateTimeArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(DateTimeArray value) {
        ZonedDateTime[] v = (ZonedDateTime[])value.asObjectCopy();
        int arrLength = v.length;
        ByteBuffer buf = ByteBuffer.allocate(5 + 24 * arrLength).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)9);
        buf.putInt(arrLength);
        for (int i = 0; i < value.length(); ++i) {
            buf.put(DateTimeValueSerializer.encode(v[i]));
        }
        return buf.array();
    }

    @Override
    public DateTimeArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrLength = buffer.getInt();
        ZonedDateTime[] arr = new ZonedDateTime[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            arr[i] = DateTimeValueSerializer.decode(buffer);
        }
        return Values.dateTimeArray(arr);
    }
}

