/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.LongArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.TimeZones;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

class DateTimeValueSerializer
implements QuickTypeSerializer<DateTimeValue> {
    protected static final int BLOCKS_DATETIME = 3;
    static final int ZONE_ID_FLAG = 0x1000000;
    static final int ZONE_ID_MASK = 0xFFFFFF;
    static final int ZONE_ID_HIGH = 0x800000;
    static final int ZONE_ID_EXT = -16777216;

    DateTimeValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(DateTimeValue value) {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value.asObjectCopy();
        byte[] data = DateTimeValueSerializer.encode(zonedDateTime);
        return ByteBuffer.allocate(1 + data.length).order(ByteOrder.BIG_ENDIAN).put((byte)10).put(data).array();
    }

    @Override
    public DateTimeValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        return DateTimeValue.datetime(DateTimeValueSerializer.decode(buffer));
    }

    public static byte[] encode(ZonedDateTime value) {
        byte[] _arr;
        long epochSecondUTC = value.toEpochSecond();
        int nano = value.getNano();
        ZoneId zone = value.getZone();
        long[] data = new long[3];
        if (zone instanceof ZoneOffset) {
            int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
            data[0] = nano;
            data[1] = epochSecondUTC;
            data[2] = offsetSeconds & 0xFFFFFF;
            _arr = LongArraySerializer.objectToBytesNoMarker(data);
        } else {
            String zoneId = zone.getId();
            short zoneNumber = TimeZones.map(zoneId);
            data[0] = nano;
            data[1] = epochSecondUTC;
            data[2] = zoneNumber | 0x1000000;
            _arr = LongArraySerializer.objectToBytesNoMarker(data);
        }
        return _arr;
    }

    public static ZonedDateTime decode(ByteBuffer buffer) {
        long nanoOfSecond = buffer.getLong();
        long epochSecondUTC = buffer.getLong();
        long encodedZone = buffer.getLong();
        if ((encodedZone & 0x1000000L) != 0L) {
            short zoneId = (short)(encodedZone & 0xFFFFFFL);
            if (TimeZones.validZoneId(zoneId)) {
                return DateTimeValue.datetimeRaw(epochSecondUTC, nanoOfSecond, ZoneId.of(TimeZones.map(zoneId)));
            }
            throw new IllegalStateException("Could not decode zone");
        }
        long zoneOffsetSeconds = (0x800000L & encodedZone) == 0x800000L ? 0xFFFFFFFFFF000000L | encodedZone : encodedZone;
        return DateTimeValue.datetimeRaw(epochSecondUTC, nanoOfSecond, ZoneOffset.ofTotalSeconds((int)zoneOffsetSeconds));
    }
}

