/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.DateValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;

class DateValueSerializer
implements QuickTypeSerializer<DateValue> {
    DateValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(DateValue value) {
        long epochDay = ((LocalDate)value.asObjectCopy()).toEpochDay();
        return ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN).put((byte)8).putLong(epochDay).array();
    }

    @Override
    public DateValue valueToObject(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buf.get();
        long epochDay = buf.getLong();
        return DateValue.epochDate(epochDay);
    }
}

