/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.DoubleArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

class DoubleArraySerializer
implements QuickTypeSerializer<DoubleArray> {
    DoubleArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(DoubleArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 8 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)11);
        buf.asDoubleBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    @Override
    public DoubleArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        double[] dest = new double[doubleBuffer.remaining()];
        doubleBuffer.get(dest);
        return Values.doubleArray(dest);
    }
}

