/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.FloatArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class FloatArraySerializer
implements QuickTypeSerializer<FloatArray> {
    FloatArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(FloatArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 4 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)16);
        buf.asFloatBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    @Override
    public FloatArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        FloatBuffer floatBuffer = buffer.asFloatBuffer();
        float[] dest = new float[floatBuffer.remaining()];
        floatBuffer.get(dest);
        return Values.floatArray(dest);
    }
}

