/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class FloatValueSerializer
implements QuickTypeSerializer<FloatValue> {
    FloatValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(FloatValue value) {
        return ByteBuffer.allocate(5).order(ByteOrder.BIG_ENDIAN).put((byte)17).putFloat(value.value()).array();
    }

    @Override
    public FloatValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        return Values.floatValue(buffer.getFloat());
    }
}

