/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.values.storable.GeoCircleValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GeoCircleValueSerializer
implements QuickTypeSerializer<GeoCircleValue> {
    GeoCircleValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(GeoCircleValue value) {
        GeoCircle geoPoint = (GeoCircle)value.asObjectCopy();
        return ByteBuffer.allocate(25).order(ByteOrder.BIG_ENDIAN).put((byte)19).putDouble(geoPoint.getLatitude()).putDouble(geoPoint.getLongitude()).putDouble(geoPoint.getRadius()).array();
    }

    @Override
    public GeoCircleValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        return Values.geoCircleValue(new GeoCircle(buffer.getDouble(), buffer.getDouble(), buffer.getDouble()));
    }
}

