/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.values.storable.GeoLineValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GeoLineValueSerializer
implements QuickTypeSerializer<GeoLineValue> {
    GeoLineValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(GeoLineValue value) {
        GeoLine geoLine = (GeoLine)value.asObjectCopy();
        GeoPoint[] points = geoLine.points();
        ByteBuffer buf = ByteBuffer.allocate(5 + 32 * points.length).order(ByteOrder.BIG_ENDIAN).put((byte)38).putInt(points.length);
        for (int i = 0; i < points.length; ++i) {
            GeoPoint gp = points[i];
            buf.putDouble(gp.getLatitude());
            buf.putDouble(gp.getLongitude());
            buf.putDouble(gp.getAltitude());
            buf.putDouble(gp.getAccuracy());
        }
        return buf.array();
    }

    @Override
    public GeoLineValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrayLength = buffer.getInt();
        GeoPoint[] points = new GeoPoint[arrayLength];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble());
        }
        return Values.geoLineValue(new GeoLine(points));
    }
}

