/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GeoPointValueSerializer
implements QuickTypeSerializer<GeoPointValue> {
    GeoPointValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(GeoPointValue value) {
        GeoPoint geoPoint = (GeoPoint)value.asObjectCopy();
        return ByteBuffer.allocate(33).order(ByteOrder.BIG_ENDIAN).put((byte)18).putDouble(geoPoint.getLatitude()).putDouble(geoPoint.getLongitude()).putDouble(geoPoint.getAltitude()).putDouble(geoPoint.getAccuracy()).array();
    }

    @Override
    public GeoPointValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        return Values.geoPointValue(new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble()));
    }
}

