/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.values.storable.GeoPolygonValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class GeoPolygonValueSerializer
implements QuickTypeSerializer<GeoPolygonValue> {
    GeoPolygonValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(GeoPolygonValue value) {
        int i;
        GeoPolygon geoPolygon = (GeoPolygon)value.asObjectCopy();
        List<GeoPoint> outerBoundary = geoPolygon.getOuterBoundary();
        List<List<GeoPoint>> holes = geoPolygon.getHoles();
        int bufferSize = 5 + 32 * outerBoundary.size() + 4;
        for (int i2 = 0; i2 < holes.size(); ++i2) {
            bufferSize += 36 * holes.get(i2).size();
        }
        ByteBuffer buf = ByteBuffer.allocate(bufferSize).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)22);
        buf.putInt(outerBoundary.size());
        for (i = 0; i < outerBoundary.size(); ++i) {
            GeoPoint gp = outerBoundary.get(i);
            buf.putDouble(gp.getLatitude());
            buf.putDouble(gp.getLongitude());
            buf.putDouble(gp.getAltitude());
            buf.putDouble(gp.getAccuracy());
        }
        buf.putInt(holes.size());
        for (i = 0; i < holes.size(); ++i) {
            List<GeoPoint> hole = holes.get(i);
            buf.putInt(hole.size());
            for (int j = 0; j < hole.size(); ++j) {
                GeoPoint gp = hole.get(j);
                buf.putDouble(gp.getLatitude());
                buf.putDouble(gp.getLongitude());
                buf.putDouble(gp.getAltitude());
                buf.putDouble(gp.getAccuracy());
            }
        }
        return buf.array();
    }

    @Override
    public GeoPolygonValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int outerBoundaryLength = buffer.getInt();
        GeoPoint[] outerBoundaryPoints = new GeoPoint[outerBoundaryLength];
        for (int i = 0; i < outerBoundaryPoints.length; ++i) {
            outerBoundaryPoints[i] = new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble());
        }
        int noHoles = buffer.getInt();
        ArrayList<List<GeoPoint>> holes = new ArrayList<List<GeoPoint>>(noHoles);
        for (int i = 0; i < noHoles; ++i) {
            int noPoints = buffer.getInt();
            ArrayList<GeoPoint> holePoints = new ArrayList<GeoPoint>(noPoints);
            for (int j = 0; j < noPoints; ++j) {
                holePoints.add(j, new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble()));
            }
            holes.add(holePoints);
        }
        return Values.geoPolygonValue(new GeoPolygon(Arrays.asList(outerBoundaryPoints), holes));
    }
}

