/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoRect;
import com.mware.ge.values.storable.GeoRectValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GeoRectValueSerializer
implements QuickTypeSerializer<GeoRectValue> {
    GeoRectValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(GeoRectValue value) {
        GeoRect geoPoint = (GeoRect)value.asObjectCopy();
        return ByteBuffer.allocate(65).order(ByteOrder.BIG_ENDIAN).put((byte)21).putDouble(geoPoint.getNorthWest().getLatitude()).putDouble(geoPoint.getNorthWest().getLongitude()).putDouble(geoPoint.getNorthWest().getAltitude()).putDouble(geoPoint.getNorthWest().getAccuracy()).putDouble(geoPoint.getSouthEast().getLatitude()).putDouble(geoPoint.getSouthEast().getLongitude()).putDouble(geoPoint.getSouthEast().getAltitude()).putDouble(geoPoint.getSouthEast().getAccuracy()).array();
    }

    @Override
    public GeoRectValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        GeoPoint northWest = new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble());
        GeoPoint southEast = new GeoPoint(buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble());
        return Values.geoRectValue(new GeoRect(northWest, southEast));
    }
}

