/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.IntArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

class IntArraySerializer
implements QuickTypeSerializer<IntArray> {
    IntArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(IntArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 4 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)24);
        buf.asIntBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    @Override
    public IntArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        IntBuffer intBuffer = buffer.asIntBuffer();
        int[] dest = new int[intBuffer.remaining()];
        intBuffer.get(dest);
        return Values.intArray(dest);
    }
}

