/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LocalDateTimeArray;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

class LocalDateTimeArraySerializer
implements QuickTypeSerializer<LocalDateTimeArray> {
    LocalDateTimeArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(LocalDateTimeArray value) {
        LocalDateTime[] v = (LocalDateTime[])value.asObjectCopy();
        int arrLength = v.length;
        ByteBuffer buf = ByteBuffer.allocate(5 + 16 * arrLength).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)35);
        buf.putInt(arrLength);
        for (int i = 0; i < value.length(); ++i) {
            long epochSecond = v[i].toEpochSecond(ZoneOffset.UTC);
            int nano = v[i].getNano();
            buf.putLong(nano);
            buf.putLong(epochSecond);
        }
        return buf.array();
    }

    @Override
    public LocalDateTimeArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrLength = buffer.getInt();
        LocalDateTime[] arr = new LocalDateTime[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            long nanos = buffer.getLong();
            long epochSecond = buffer.getLong();
            arr[i] = LocalDateTimeValue.localDateTimeRaw(epochSecond, nanos);
        }
        return Values.localDateTimeArray(arr);
    }
}

