/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LocalDateTimeValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

class LocalDateTimeValueSerializer
implements QuickTypeSerializer<LocalDateTimeValue> {
    LocalDateTimeValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(LocalDateTimeValue value) {
        LocalDateTime localDateTime = (LocalDateTime)value.asObjectCopy();
        long epochSecond = localDateTime.toEpochSecond(ZoneOffset.UTC);
        int nano = localDateTime.getNano();
        return ByteBuffer.allocate(17).order(ByteOrder.BIG_ENDIAN).put((byte)32).putLong(nano).putLong(epochSecond).array();
    }

    @Override
    public LocalDateTimeValue valueToObject(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buf.get();
        long nanos = buf.getLong();
        long epochSecond = buf.getLong();
        return LocalDateTimeValue.localDateTime(epochSecond, nanos);
    }
}

