/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LocalTimeArray;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalTime;

class LocalTimeArraySerializer
implements QuickTypeSerializer<LocalTimeArray> {
    LocalTimeArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(LocalTimeArray value) {
        LocalTime[] v = (LocalTime[])value.asObjectCopy();
        int arrLength = v.length;
        ByteBuffer buf = ByteBuffer.allocate(5 + 8 * arrLength).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)37);
        buf.putInt(arrLength);
        for (int i = 0; i < value.length(); ++i) {
            buf.putLong(v[i].toNanoOfDay());
        }
        return buf.array();
    }

    @Override
    public LocalTimeArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrLength = buffer.getInt();
        LocalTime[] arr = new LocalTime[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            long nanosOfDayUTC = buffer.getLong();
            arr[i] = LocalTimeValue.localTimeRaw(nanosOfDayUTC);
        }
        return Values.localTimeArray(arr);
    }
}

