/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LocalTimeValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalTime;

class LocalTimeValueSerializer
implements QuickTypeSerializer<LocalTimeValue> {
    LocalTimeValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(LocalTimeValue value) {
        LocalTime localTime = (LocalTime)value.asObjectCopy();
        long nanosOfDayUTC = localTime.toNanoOfDay();
        return ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN).put((byte)34).putLong(nanosOfDayUTC).array();
    }

    @Override
    public LocalTimeValue valueToObject(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buf.get();
        long nanosOfDayUTC = buf.getLong();
        return LocalTimeValue.localTime(nanosOfDayUTC);
    }
}

