/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LongArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

class LongArraySerializer
implements QuickTypeSerializer<LongArray> {
    LongArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(LongArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 8 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)26);
        buf.asLongBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    public static byte[] objectToBytesNoMarker(long[] value) {
        byte[] bytes = new byte[8 * value.length];
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        buf.asLongBuffer().put(value);
        return bytes;
    }

    @Override
    public LongArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        LongBuffer doubleBuffer = buffer.asLongBuffer();
        long[] dest = new long[doubleBuffer.remaining()];
        doubleBuffer.get(dest);
        return Values.longArray(dest);
    }
}

