/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LongValueSerializer
implements QuickTypeSerializer<LongValue> {
    LongValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(LongValue value) {
        return ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN).put((byte)27).putLong(value.longValue()).array();
    }

    @Override
    public LongValue valueToObject(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buf.get();
        long v = buf.getLong();
        return Values.longValue(v);
    }
}

