/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.GeException;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.BooleanArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.BooleanValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.ByteArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.ByteValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.CharArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.CharValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DateArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DateTimeArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DateTimeValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DateValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DoubleArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.DoubleValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.FloatArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.FloatValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoCircleValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoHashValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoLineValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoPointValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoPolygonValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.GeoRectValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.IntArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.IntValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.KryoQuickTypeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LocalDateTimeArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LocalDateTimeValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LocalTimeArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LocalTimeValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LongArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.LongValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.ShortArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.ShortValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.StringArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.StringValueSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.TimeArraySerializer;
import com.mware.ge.serializer.kryo.quickSerializers.TimeValueSerializer;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.values.storable.BooleanArray;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.ByteValue;
import com.mware.ge.values.storable.CharArray;
import com.mware.ge.values.storable.CharValue;
import com.mware.ge.values.storable.DateArray;
import com.mware.ge.values.storable.DateTimeArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DoubleArray;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.FloatArray;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.GeoCircleValue;
import com.mware.ge.values.storable.GeoHashValue;
import com.mware.ge.values.storable.GeoLineValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.GeoPolygonValue;
import com.mware.ge.values.storable.GeoRectValue;
import com.mware.ge.values.storable.IntArray;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.LocalDateTimeArray;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.LocalTimeArray;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.LongArray;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.ShortArray;
import com.mware.ge.values.storable.ShortValue;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.TimeArray;
import com.mware.ge.values.storable.TimeValue;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class QuickKryoGeSerializer
implements GeSerializer {
    private GeLogger LOGGER = GeLoggerFactory.getLogger(QuickKryoGeSerializer.class);
    private static final byte[] EMPTY = new byte[0];
    public static final String CONFIG_COMPRESS = "serializer.enableCompression";
    public static final boolean CONFIG_COMPRESS_DEFAULT = false;
    private final boolean enableCompression;
    private QuickTypeSerializer defaultQuickTypeSerializer = new KryoQuickTypeSerializer();
    private Map<Class, QuickTypeSerializer> quickTypeSerializersByClass = new HashMap<Class, QuickTypeSerializer>(){
        {
            this.put(BooleanValue.class, new BooleanValueSerializer());
            this.put(BooleanArray.class, new BooleanArraySerializer());
            this.put(ByteValue.class, new ByteValueSerializer());
            this.put(ByteArray.class, new ByteArraySerializer());
            this.put(CharValue.class, new CharValueSerializer());
            this.put(CharArray.class, new CharArraySerializer());
            this.put(DoubleValue.class, new DoubleValueSerializer());
            this.put(DoubleArray.class, new DoubleArraySerializer());
            this.put(FloatValue.class, new FloatValueSerializer());
            this.put(FloatArray.class, new FloatArraySerializer());
            this.put(IntValue.class, new IntValueSerializer());
            this.put(IntArray.class, new IntArraySerializer());
            this.put(ShortValue.class, new ShortValueSerializer());
            this.put(ShortArray.class, new ShortArraySerializer());
            this.put(LongValue.class, new LongValueSerializer());
            this.put(LongArray.class, new LongArraySerializer());
            this.put(StringValue.class, new StringValueSerializer());
            this.put(StringArray.class, new StringArraySerializer());
            this.put(DateTimeValue.class, new DateTimeValueSerializer());
            this.put(DateTimeArray.class, new DateTimeArraySerializer());
            this.put(DateValue.class, new DateValueSerializer());
            this.put(DateArray.class, new DateArraySerializer());
            this.put(LocalDateTimeValue.class, new LocalDateTimeValueSerializer());
            this.put(LocalDateTimeArray.class, new LocalDateTimeArraySerializer());
            this.put(TimeValue.class, new TimeValueSerializer());
            this.put(TimeArray.class, new TimeArraySerializer());
            this.put(LocalTimeValue.class, new LocalTimeValueSerializer());
            this.put(LocalTimeArray.class, new LocalTimeArraySerializer());
            this.put(GeoPointValue.class, new GeoPointValueSerializer());
            this.put(GeoCircleValue.class, new GeoCircleValueSerializer());
            this.put(GeoLineValue.class, new GeoLineValueSerializer());
            this.put(GeoRectValue.class, new GeoRectValueSerializer());
            this.put(GeoHashValue.class, new GeoHashValueSerializer());
            this.put(GeoPolygonValue.class, new GeoPolygonValueSerializer());
        }
    };
    private Map<Byte, QuickTypeSerializer> quickTypeSerializersByMarker = new HashMap<Byte, QuickTypeSerializer>(){
        {
            this.put((byte)1, new BooleanValueSerializer());
            this.put((byte)2, new BooleanArraySerializer());
            this.put((byte)3, new ByteValueSerializer());
            this.put((byte)4, new ByteArraySerializer());
            this.put((byte)5, new CharValueSerializer());
            this.put((byte)6, new CharArraySerializer());
            this.put((byte)12, new DoubleValueSerializer());
            this.put((byte)11, new DoubleArraySerializer());
            this.put((byte)17, new FloatValueSerializer());
            this.put((byte)16, new FloatArraySerializer());
            this.put((byte)25, new IntValueSerializer());
            this.put((byte)24, new IntArraySerializer());
            this.put((byte)29, new ShortValueSerializer());
            this.put((byte)28, new ShortArraySerializer());
            this.put((byte)27, new LongValueSerializer());
            this.put((byte)26, new LongArraySerializer());
            this.put((byte)31, new StringValueSerializer());
            this.put((byte)30, new StringArraySerializer());
            this.put((byte)10, new DateTimeValueSerializer());
            this.put((byte)9, new DateTimeArraySerializer());
            this.put((byte)8, new DateValueSerializer());
            this.put((byte)7, new DateArraySerializer());
            this.put((byte)32, new LocalDateTimeValueSerializer());
            this.put((byte)35, new LocalDateTimeArraySerializer());
            this.put((byte)33, new TimeValueSerializer());
            this.put((byte)36, new TimeArraySerializer());
            this.put((byte)34, new LocalTimeValueSerializer());
            this.put((byte)37, new LocalTimeArraySerializer());
            this.put((byte)18, new GeoPointValueSerializer());
            this.put((byte)19, new GeoCircleValueSerializer());
            this.put((byte)38, new GeoLineValueSerializer());
            this.put((byte)21, new GeoRectValueSerializer());
            this.put((byte)23, new GeoHashValueSerializer());
            this.put((byte)22, new GeoPolygonValueSerializer());
            this.put((byte)0, new KryoQuickTypeSerializer());
        }
    };

    public QuickKryoGeSerializer(GraphConfiguration config) {
        this(config.getBoolean(CONFIG_COMPRESS, false));
    }

    public QuickKryoGeSerializer(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    @Override
    public byte[] objectToBytes(Object object) {
        if (object == null) {
            return EMPTY;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByClass.get(object.getClass());
        if (quickTypeSerializer == null) {
            quickTypeSerializer = this.quickTypeSerializersByClass.get(object.getClass().getSuperclass());
        }
        if (object.getClass().getName().contains("GeoCollection")) {
            this.LOGGER.warn("### No optimized serializer for GeoCollection implemented", new Object[0]);
        }
        byte[] bytes = quickTypeSerializer != null ? quickTypeSerializer.objectToBytes(object) : this.defaultQuickTypeSerializer.objectToBytes(object);
        return this.compress(bytes);
    }

    @Override
    public <T> T bytesToObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByMarker.get((bytes = this.expand(bytes))[0]);
        if (quickTypeSerializer != null) {
            return quickTypeSerializer.valueToObject(bytes);
        }
        throw new GeException("Invalid marker: " + Integer.toHexString(bytes[0]));
    }

    protected byte[] compress(byte[] bytes) {
        if (!this.enableCompression) {
            return bytes;
        }
        Deflater deflater = new Deflater(9);
        try {
            deflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new GeException("Could not compress bytes", ex);
        }
        finally {
            deflater.end();
        }
    }

    protected byte[] expand(byte[] bytes) {
        if (!this.enableCompression) {
            return bytes;
        }
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new GeException("Could not decompress bytes", ex);
        }
        finally {
            inflater.end();
        }
    }
}

