/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.ShortArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

class ShortArraySerializer
implements QuickTypeSerializer<ShortArray> {
    ShortArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(ShortArray value) {
        ByteBuffer buf = ByteBuffer.allocate(1 + 2 * value.length()).order(ByteOrder.BIG_ENDIAN).put((byte)28);
        buf.asShortBuffer().put(value.asObjectCopy());
        return buf.array();
    }

    @Override
    public ShortArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        ShortBuffer shortBuffer = buffer.asShortBuffer();
        short[] dest = new short[shortBuffer.remaining()];
        shortBuffer.get(dest);
        return Values.shortArray(dest);
    }
}

