/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.ShortValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class ShortValueSerializer
implements QuickTypeSerializer<ShortValue> {
    ShortValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(ShortValue value) {
        return ByteBuffer.allocate(3).order(ByteOrder.BIG_ENDIAN).put((byte)29).putShort(value.value()).array();
    }

    @Override
    public ShortValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        return Values.shortValue(buffer.getShort());
    }
}

