/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.util.UTF8;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class StringArraySerializer
implements QuickTypeSerializer<StringArray> {
    private Charset charset = StandardCharsets.UTF_8;

    StringArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(StringArray value) {
        String[] arr = value.asObjectCopy();
        int arrByteLength = 0;
        for (int i = 0; i < arr.length; ++i) {
            arrByteLength += 4 + arr[i].getBytes(this.charset).length;
        }
        ByteBuffer buf = ByteBuffer.allocate(5 + arrByteLength).order(ByteOrder.BIG_ENDIAN).put((byte)30).putInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            byte[] valueBytes = arr[i].getBytes(this.charset);
            buf.putInt(valueBytes.length);
            buf.put(valueBytes);
        }
        return buf.array();
    }

    @Override
    public StringArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrayLength = buffer.getInt();
        String[] result = new String[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            int byteLength = buffer.getInt();
            result[i] = UTF8.decode(buffer.array(), buffer.position(), byteLength);
            buffer.position(buffer.position() + byteLength);
        }
        return (StringArray)Values.stringArray(result);
    }
}

