/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.util.UTF8;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.Values;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class StringValueSerializer
implements QuickTypeSerializer<StringValue> {
    StringValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(StringValue value) {
        byte[] valueBytes = UTF8.encode(value.stringValue());
        return ByteBuffer.allocate(5 + valueBytes.length).order(ByteOrder.BIG_ENDIAN).put((byte)31).putInt(valueBytes.length).put(valueBytes).array();
    }

    @Override
    public StringValue valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int count = buffer.getInt();
        int remaining = buffer.remaining();
        if (count > remaining) {
            throw new IllegalArgumentException("Bad string format; claims string is " + count + " bytes long, but only " + remaining + " bytes remain in buffer");
        }
        byte[] valueBytes = new byte[count];
        buffer.get(valueBytes);
        return (StringValue)Values.stringValue(UTF8.decode(valueBytes));
    }
}

