/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.TimeArray;
import com.mware.ge.values.storable.Values;
import com.mware.ge.values.utils.TemporalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;

class TimeArraySerializer
implements QuickTypeSerializer<TimeArray> {
    TimeArraySerializer() {
    }

    @Override
    public byte[] objectToBytes(TimeArray value) {
        OffsetTime[] v = (OffsetTime[])value.asObjectCopy();
        int arrLength = v.length;
        ByteBuffer buf = ByteBuffer.allocate(5 + 12 * arrLength).order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)36);
        buf.putInt(arrLength);
        for (int i = 0; i < value.length(); ++i) {
            long nanosOfDayUTC = TemporalUtil.getNanosOfDayUTC(v[i]);
            int offsetSeconds = v[i].getOffset().getTotalSeconds();
            buf.putLong(nanosOfDayUTC);
            buf.putInt(offsetSeconds);
        }
        return buf.array();
    }

    @Override
    public TimeArray valueToObject(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buffer.get();
        int arrLength = buffer.getInt();
        OffsetTime[] arr = new OffsetTime[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            long nanosOfDayUTC = buffer.getLong();
            int offsetSeconds = buffer.getInt();
            arr[i] = OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), ZoneOffset.ofTotalSeconds(offsetSeconds));
        }
        return Values.timeArray(arr);
    }
}

