/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer.kryo.quickSerializers;

import com.mware.ge.serializer.kryo.quickSerializers.QuickTypeSerializer;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.utils.TemporalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;

class TimeValueSerializer
implements QuickTypeSerializer<TimeValue> {
    TimeValueSerializer() {
    }

    @Override
    public byte[] objectToBytes(TimeValue value) {
        OffsetTime offsetTime = (OffsetTime)value.asObjectCopy();
        long nanosOfDayUTC = TemporalUtil.getNanosOfDayUTC(offsetTime);
        int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
        return ByteBuffer.allocate(13).order(ByteOrder.BIG_ENDIAN).put((byte)33).putLong(nanosOfDayUTC).putInt(offsetSeconds).array();
    }

    @Override
    public TimeValue valueToObject(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        buf.get();
        long nanosOfDayUTC = buf.getLong();
        int offsetSeconds = buf.getInt();
        OffsetTime v = OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), ZoneOffset.ofTotalSeconds(offsetSeconds));
        return TimeValue.time(v);
    }
}

